/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.property;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;

public class PropertyMatrixAction
extends AbstractAction {
    private OWLModel owlModel;

    public PropertyMatrixAction(OWLModel oWLModel) {
        super("Show properties list", OWLIcons.getImageIcon("PropertyMatrix"));
        this.owlModel = oWLModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MatrixFilter matrixFilter = new MatrixFilter(){

            public Collection getInitialValues() {
                Collection collection = PropertyMatrixAction.this.owlModel.getVisibleUserDefinedRDFProperties();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    RDFResource rDFResource = (RDFResource)iterator.next();
                    if (this.isSuitable(rDFResource)) continue;
                    iterator.remove();
                }
                return collection;
            }

            public String getName() {
                return "All Properties";
            }

            public boolean isSuitable(RDFResource rDFResource) {
                return rDFResource instanceof RDFProperty && rDFResource.isVisible() && (rDFResource.isEditable() || rDFResource.isIncluded());
            }
        };
        MatrixPanel matrixPanel = new MatrixPanel(this.owlModel, matrixFilter, new PropertyMatrixTableModel(this.owlModel, matrixFilter));
        ResultsPanelManager.addResultsPanel(this.owlModel, matrixPanel, true);
    }
}

