/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.TableCellRenderer;

public class ExistentialMatrixColumn
implements DependentMatrixColumn,
MatrixColumn {
    private RDFProperty property;

    public ExistentialMatrixColumn(RDFProperty rDFProperty) {
        this.property = rDFProperty;
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            protected void loadCls(Cls cls) {
                if (cls instanceof OWLNamedClass) {
                    Collection collection = ExistentialMatrixColumn.this.getMatchingRestrictions((OWLNamedClass)cls);
                    this.setGrayedSecondaryText(false);
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        OWLSomeValuesFrom oWLSomeValuesFrom = (OWLSomeValuesFrom)iterator.next();
                        this.addText(oWLSomeValuesFrom.getFillerText());
                        if (!iterator.hasNext()) continue;
                        this.addText(", ");
                    }
                }
            }
        };
    }

    private Collection getMatchingRestrictions(OWLNamedClass oWLNamedClass) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        if (oWLNamedClass.getDefinition() == null) {
            for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
                if (!(cls instanceof OWLSomeValuesFrom) || !this.property.equals(((OWLSomeValuesFrom)cls).getOnProperty())) continue;
                arrayList.add(cls);
            }
        }
        return arrayList;
    }

    public String getName() {
        return "\u2203 " + this.property.getBrowserText();
    }

    public RDFProperty getProperty() {
        return this.property;
    }

    public int getWidth() {
        return 200;
    }

    public boolean isDependentOn(RDFResource rDFResource) {
        return this.property.equals(rDFResource);
    }
}

