/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ExistentialMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClassMatrixPanel
extends MatrixPanel {
    private ResourceSelectionAction addExistentialAction = new ResourceSelectionAction("Add someValuesFrom column...", OWLIcons.getAddIcon("OWLSomeValuesFrom")){

        public void resourceSelected(RDFResource rDFResource) {
            RDFProperty rDFProperty = (RDFProperty)rDFResource;
            ExistentialMatrixColumn existentialMatrixColumn = new ExistentialMatrixColumn(rDFProperty);
            ClassMatrixPanel.this.getTable().addColumn(existentialMatrixColumn);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(ClassMatrixPanel.this, ClassMatrixPanel.this.getOWLModel(), this.getSelectableResources(), "Select a property");
        }

        public Collection getSelectableResources() {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)ClassMatrixPanel.this.getTable().getSelectedInstance();
            Collection collection = ClassMatrixPanel.getPotentialProperties(rDFSNamedClass);
            int n = ClassMatrixPanel.this.getTableModel().getColumnCount();
            for (int i = 0; i < n; ++i) {
                MatrixColumn matrixColumn = ClassMatrixPanel.this.getTableModel().getMatrixColumn(i);
                if (!(matrixColumn instanceof ExistentialMatrixColumn)) continue;
                collection.remove(((ExistentialMatrixColumn)matrixColumn).getProperty());
            }
            return collection;
        }
    };

    public ClassMatrixPanel(OWLModel oWLModel, MatrixFilter matrixFilter) {
        this(oWLModel, matrixFilter, new ClassMatrixTableModel(oWLModel, matrixFilter));
    }

    public ClassMatrixPanel(OWLModel oWLModel, MatrixFilter matrixFilter, MatrixTableModel matrixTableModel) {
        super(oWLModel, matrixFilter, matrixTableModel);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClassMatrixPanel.this.updateActions();
            }
        });
        this.addButton(this.addExistentialAction);
        this.updateActions();
    }

    static Collection getPotentialProperties(RDFSNamedClass rDFSNamedClass) {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : rDFSNamedClass.getUnionDomainProperties(true)) {
            if (!(rDFProperty instanceof OWLObjectProperty) || ((OWLObjectProperty)rDFProperty).isAnnotationProperty()) continue;
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    private void updateActions() {
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getTable().getSelectedInstance();
        boolean bl = rDFSNamedClass instanceof OWLNamedClass;
        this.addExistentialAction.setEnabled(bl);
    }
}

