/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class MultiSlotPanel
extends JPanel {
    private Cls cls;
    private BrowserSlotPattern pattern;
    private List panels = new ArrayList();

    public MultiSlotPanel(BrowserSlotPattern browserSlotPattern, Cls cls) {
        this.cls = cls;
        this.pattern = browserSlotPattern;
        this.createUI();
        this.loadUI();
    }

    private void createUI() {
        this.setLayout(new GridLayout(2, 10, 0, 4));
        this.add(ComponentFactory.createLabel((String)"Set display properties and optional text:"));
        Collection collection = this.cls.getVisibleTemplateSlots();
        JPanel jPanel = new JPanel(new FlowLayout());
        for (int i = 0; i < 5; ++i) {
            jPanel.add(this.createTextPanel());
            jPanel.add(this.createSlotPanel(collection));
        }
        jPanel.add(this.createTextPanel());
        this.add(jPanel);
    }

    private void loadUI() {
        if (this.pattern != null) {
            Iterator iterator = this.panels.iterator();
            Iterator iterator2 = this.pattern.getElements().iterator();
            while (iterator2.hasNext() && iterator.hasNext()) {
                JComponent jComponent;
                Object e = iterator2.next();
                Object e2 = iterator.next();
                if (e instanceof String) {
                    if (!(e2 instanceof JTextField)) {
                        e2 = iterator.next();
                    }
                    jComponent = (JTextField)e2;
                    ((JTextComponent)jComponent).setText((String)e);
                    continue;
                }
                if (!(e2 instanceof JComboBox)) {
                    e2 = iterator.next();
                }
                jComponent = (JComboBox)e2;
                ((JComboBox)jComponent).setSelectedItem(e);
            }
        }
    }

    private JComponent createTextPanel() {
        JTextField jTextField = ComponentFactory.createTextField();
        jTextField.setColumns(2);
        this.panels.add(jTextField);
        return jTextField;
    }

    private JComponent createSlotPanel(Collection collection) {
        JComboBox jComboBox = ComponentFactory.createComboBox();
        jComboBox.setRenderer(new FrameRenderer());
        ArrayList arrayList = new ArrayList(collection);
        arrayList.add(0, null);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setSelectedItem(null);
        this.panels.add(jComboBox);
        return jComboBox;
    }

    public BrowserSlotPattern getBrowserTextPattern() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : this.panels) {
            Object object;
            JComponent jComponent;
            if (e instanceof JTextField) {
                jComponent = (JTextField)e;
                object = ((JTextComponent)jComponent).getText();
                if (object == null || ((String)object).length() <= 0) continue;
                arrayList.add(object);
                continue;
            }
            jComponent = (JComboBox)e;
            object = ((JComboBox)jComponent).getSelectedItem();
            if (object == null) continue;
            arrayList.add(object);
        }
        return new BrowserSlotPattern(arrayList);
    }
}

