/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeNode;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreeRoot;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ImportsTree
extends SelectableTree
implements HostResourceDisplay {
    private static int MAX_EXPANSIONS = 50;
    private OWLOntology rootOntology;

    public ImportsTree(OWLOntology oWLOntology) {
        super(null, (LazyTreeRoot)new ImportsTreeRoot(oWLOntology));
        this.rootOntology = oWLOntology;
        this.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer()));
        this.setRootVisible(false);
        ComponentUtilities.fullSelectionExpand((JTree)((Object)this), (int)MAX_EXPANSIONS);
    }

    private void addResources(Set set, ImportsTreeNode importsTreeNode) {
        Object object = importsTreeNode.getUserObject();
        if (!set.contains(object)) {
            set.add(object);
            for (int i = 0; i < importsTreeNode.getChildCount(); ++i) {
                ImportsTreeNode importsTreeNode2 = (ImportsTreeNode)((Object)importsTreeNode.getChildAt(i));
                this.addResources(set, importsTreeNode2);
            }
        }
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    public Set getSelectedResources() {
        HashSet<Object> hashSet = new HashSet<Object>();
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                ImportsTreeNode importsTreeNode = (ImportsTreeNode)((Object)treePath.getLastPathComponent());
                hashSet.add(importsTreeNode.getUserObject());
            }
        } else {
            LazyTreeRoot lazyTreeRoot = (LazyTreeRoot)this.getModel().getRoot();
            this.addResources(hashSet, (ImportsTreeNode)((Object)lazyTreeRoot.getChildAt(0)));
        }
        return hashSet;
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        if (this.rootOntology == null) {
            Log.getLogger().warning("Root ontology = null!");
            return false;
        }
        boolean bl = false;
        if (rDFResource instanceof OWLOntology) {
            ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
            arrayList.add(rDFResource);
            Collection collection = this.rootOntology.getOWLModel().getOWLOntologies();
            while (!arrayList.contains(this.rootOntology)) {
                for (OWLOntology oWLOntology : collection) {
                    OWLOntology oWLOntology2 = (OWLOntology)arrayList.get(arrayList.size() - 1);
                    if (!oWLOntology.getImports().contains(oWLOntology2.getURI().toString())) continue;
                    arrayList.add(oWLOntology);
                }
            }
            this.setSelectionPath(ComponentUtilities.getTreePath((JTree)((Object)this), arrayList));
            bl = true;
        }
        return bl;
    }
}

