/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteLayoutNames;
import edu.stanford.smi.protegex.owl.ui.forms.DefaultWidgetClassMapper;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.WidgetClassMapper;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AbsoluteFormsGenerator {
    private static final Set ignoreSystemClasses = new HashSet();
    public static boolean optional;
    public static final String SAVE_FORMS_KEY;
    public static final String ALL = "all";
    public static final String MODIFIED = "modified";
    private OWLModel owlModel;
    private Project project;
    private WidgetClassMapper widgetClassMapper = new DefaultWidgetClassMapper();
    public static final String SUFFIX = ".forms";
    public static final String FILE_NAME = "protege-system.forms";
    public static final String PROTEGE_SYSTEM_FORMS_URI = "http://www.owl-ontologies.com/forms/protege-system.forms";

    public AbsoluteFormsGenerator(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.project = oWLModel.getProject();
    }

    private void createFormWidget(Model model, RDFSNamedClass rDFSNamedClass, boolean bl) {
        ClsWidget clsWidget;
        if ((bl || this.project.hasCustomizedDescriptor((Cls)rDFSNamedClass)) && (clsWidget = this.project.getDesignTimeClsWidget((Cls)rDFSNamedClass)) != null && !rDFSNamedClass.getName().startsWith("protege:")) {
            this.createFormWidget(model, rDFSNamedClass, clsWidget);
        }
    }

    private void createFormWidget(Model model, RDFSNamedClass rDFSNamedClass, ClsWidget clsWidget) {
        String string = model.getNsPrefixURI("");
        String string2 = rDFSNamedClass.getName().replace(':', '_');
        Resource resource = model.createResource(string + string2, (Resource)FormsNames.FormWidget);
        resource.addProperty((Property)FormsNames.forClass, (RDFNode)model.createResource(rDFSNamedClass.getURI()));
        for (Slot slot : this.owlModel.getSlots()) {
            Object object;
            RDFProperty rDFProperty;
            SlotWidget slotWidget = clsWidget.getSlotWidget(slot);
            if (slotWidget == null) continue;
            String string3 = slotWidget.getDescriptor().getWidgetClassName();
            String string4 = this.widgetClassMapper.getWidgetClassURI(string3);
            OntClass ontClass = FormsNames.Widget;
            if (string4 != null) {
                ontClass = model.createResource(string4);
            }
            Resource resource2 = model.createResource(null, (Resource)ontClass);
            resource.addProperty((Property)FormsNames.widgets, (RDFNode)resource2);
            if (slot instanceof RDFProperty) {
                rDFProperty = (RDFProperty)slot;
                object = rDFProperty.getNamespace();
                if (object != null) {
                    resource2.addProperty((Property)FormsNames.forProperty, (RDFNode)model.createResource(rDFProperty.getURI()));
                }
            } else {
                resource2.addProperty(RDFS.comment, slot.getName());
            }
            if (ontClass.equals(FormsNames.Widget)) {
                resource2.addProperty((Property)ProtegeFormsNames.javaClassName, string3);
            }
            rDFProperty = model.createResource(null, (Resource)AbsoluteLayoutNames.AbsoluteLayoutData);
            resource2.addProperty((Property)FormsNames.layoutData, (RDFNode)rDFProperty);
            object = slotWidget.getDescriptor().getBounds();
            rDFProperty.addProperty((Property)AbsoluteLayoutNames.x, (RDFNode)model.createLiteral((long)((int)((Rectangle)object).getX())));
            rDFProperty.addProperty((Property)AbsoluteLayoutNames.y, (RDFNode)model.createLiteral((long)((int)((Rectangle)object).getY())));
            rDFProperty.addProperty((Property)AbsoluteLayoutNames.width, (RDFNode)model.createLiteral((long)((int)((Rectangle)object).getWidth())));
            rDFProperty.addProperty((Property)AbsoluteLayoutNames.height, (RDFNode)model.createLiteral((long)((int)((Rectangle)object).getHeight())));
        }
    }

    public Model createModel(TripleStore tripleStore, boolean bl) {
        Model model = ModelFactory.createDefaultModel();
        String string = this.getFormsFileURI(tripleStore);
        model.setNsPrefix("", string + "#");
        model.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        model.setNsPrefix("rdf", RDF.getURI());
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("forms", "http://www.owl-ontologies.com/forms/forms.owl#");
        model.setNsPrefix("absolute", "http://www.owl-ontologies.com/forms/absolute.owl#");
        model.setNsPrefix("pforms", "http://www.owl-ontologies.com/forms/protege.owl#");
        Resource resource = model.createResource(string);
        resource.addProperty(RDF.type, (RDFNode)OWL.Ontology);
        String string2 = "http://www.owl-ontologies.com/forms/protege.owl#";
        String string3 = "http://www.owl-ontologies.com/forms/absolute.owl#";
        resource.addProperty(OWL.imports, (RDFNode)model.createResource(string2.substring(0, string2.length() - 1)));
        resource.addProperty(OWL.imports, (RDFNode)model.createResource(string3.substring(0, string3.length() - 1)));
        if (tripleStore == this.owlModel.getTripleStoreModel().getTripleStore(0)) {
            for (Cls cls : this.owlModel.getClses()) {
                if (!cls.isSystem() || !(cls instanceof RDFSNamedClass) || ignoreSystemClasses.contains(cls.getName())) continue;
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)cls;
                this.createFormWidget(model, rDFSNamedClass, bl);
            }
        } else {
            Iterator iterator = tripleStore.listHomeResources();
            while (iterator.hasNext()) {
                RDFResource rDFResource = (RDFResource)iterator.next();
                if (!(rDFResource instanceof RDFSNamedClass)) continue;
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource;
                this.createFormWidget(model, rDFSNamedClass, bl);
            }
        }
        return model;
    }

    private String getFormsFileURI(TripleStore tripleStore) {
        return AbsoluteFormsGenerator.getFormsFileURI(tripleStore, this.owlModel);
    }

    public static String getFormsFileURI(TripleStore tripleStore, OWLModel oWLModel) {
        String string = tripleStore.getName();
        if (tripleStore == oWLModel.getTripleStoreModel().getTopTripleStore()) {
            string = oWLModel.getDefaultOWLOntology().getURI();
        } else if (tripleStore == oWLModel.getTripleStoreModel().getTripleStore(0)) {
            return PROTEGE_SYSTEM_FORMS_URI;
        }
        if (string.endsWith("#")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + SUFFIX;
        return string;
    }

    public void generateFiles(String string) throws Exception {
        Iterator iterator = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (iterator.hasNext()) {
            Object object;
            String string2;
            PrintStream printStream;
            Object object2;
            File file;
            Object object3;
            TripleStore tripleStore = (TripleStore)iterator.next();
            String string3 = this.getFormsFileURI(tripleStore);
            URI uRI = new URI(tripleStore.getName());
            URI uRI2 = new URI(string3);
            Repository repository = this.owlModel.getRepositoryManager().getRepository(uRI);
            if (repository != null) {
                if (!repository.isWritable(uRI)) continue;
                System.out.println("Saving .forms model " + uRI2 + " to " + repository.getOntologyLocationDescription(uRI2));
                object3 = repository.getOutputStream(uRI2);
                file = this.createModel(tripleStore, ALL.equals(string));
                object2 = "RDF/XML-ABBREV";
                printStream = new PrintStream((OutputStream)object3);
                string2 = file.getNsPrefixURI("");
                object = file.getWriter((String)object2);
                Jena.prepareWriter(object, (String)object2, string2);
                object.write((Model)file, (OutputStream)printStream, string2);
                ((OutputStream)object3).close();
                continue;
            }
            if (tripleStore != this.owlModel.getTripleStoreModel().getTopTripleStore() || !(this.owlModel instanceof JenaOWLModel)) continue;
            object3 = ((JenaOWLModel)this.owlModel).getOWLFilePath() + SUFFIX;
            file = new File((String)object3);
            System.out.println("Saving .forms model " + uRI2 + " to " + file);
            object2 = new FileOutputStream(file);
            printStream = this.createModel(tripleStore, ALL.equals(string));
            string2 = "RDF/XML-ABBREV";
            object = new PrintStream((OutputStream)object2);
            String string4 = printStream.getNsPrefixURI("");
            RDFWriter rDFWriter = printStream.getWriter(string2);
            Jena.prepareWriter(rDFWriter, string2, string4);
            rDFWriter.write((Model)printStream, (OutputStream)object, string4);
            ((OutputStream)object2).close();
        }
    }

    private void saveSystemForms(String string) throws IOException {
        File file = new File(FILE_NAME);
        System.out.println("Saving system forms model to " + file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        TripleStore tripleStore = this.owlModel.getTripleStoreModel().getTripleStore(0);
        Model model = this.createModel(tripleStore, ALL.equals(string));
        String string2 = "RDF/XML-ABBREV";
        PrintStream printStream = new PrintStream(fileOutputStream);
        String string3 = "http://www.owl-ontologies.com/forms/protege-system.forms#";
        RDFWriter rDFWriter = model.getWriter(string2);
        Jena.prepareWriter(rDFWriter, string2, string3);
        rDFWriter.write(model, (OutputStream)printStream, string3);
        ((OutputStream)fileOutputStream).close();
    }

    static {
        ignoreSystemClasses.add("owl:AllDifferent");
        ignoreSystemClasses.add("owl:AllValuesFromRestriction");
        ignoreSystemClasses.add("owl:AnnotationProperty");
        ignoreSystemClasses.add(":OWL-ANONYMOUS-ROOT");
        ignoreSystemClasses.add("owl:CardinalityRestriction");
        ignoreSystemClasses.add("owl:ComplementClass");
        ignoreSystemClasses.add("owl:DataRange");
        ignoreSystemClasses.add("owl:DeprecatedClass");
        ignoreSystemClasses.add("owl:DeprecatedProperty");
        ignoreSystemClasses.add("owl:EnumeratedClass");
        ignoreSystemClasses.add("owl:FunctionalProperty");
        ignoreSystemClasses.add("owl:HasValueRestriction");
        ignoreSystemClasses.add("owl:IntersectionClass");
        ignoreSystemClasses.add("owl:InverseFunctionalProperty");
        ignoreSystemClasses.add("owl:LogicalClass");
        ignoreSystemClasses.add("owl:MaxCardinalityRestriction");
        ignoreSystemClasses.add("owl:MinCardinalityRestriction");
        ignoreSystemClasses.add("owl:Nothing");
        ignoreSystemClasses.add("owl:Restriction");
        ignoreSystemClasses.add("owl:SomeValuesFromRestriction");
        ignoreSystemClasses.add("owl:SymmetricProperty");
        ignoreSystemClasses.add("owl:TransitiveProperty");
        ignoreSystemClasses.add("owl:UnionClass");
        ignoreSystemClasses.add("rdf:Alt");
        ignoreSystemClasses.add("rdf:Bag");
        ignoreSystemClasses.add("rdf:Description");
        ignoreSystemClasses.add("rdf:List");
        ignoreSystemClasses.add("rdf:Seq");
        ignoreSystemClasses.add("rdf:Statement");
        ignoreSystemClasses.add("rdfs:Container");
        ignoreSystemClasses.add("rdfs:Literal");
        optional = true;
        SAVE_FORMS_KEY = AbsoluteFormsGenerator.class.getName() + ".saveForms";
    }
}

