/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JCalendar;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.DateValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class DateTimeValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return DateValueEditor.canEdit(rDFResource.getOWLModel().getXSDdateTime(), rDFResource, rDFProperty, object);
    }

    public Object createDefaultValue(RDFResource rDFResource, RDFProperty rDFProperty) {
        String string = XMLSchemaDatatypes.getDefaultDateTimeValue();
        return this.createRDFSLiteral(rDFProperty.getOWLModel(), string);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel oWLModel, String string) {
        return oWLModel.createRDFSLiteral(string, oWLModel.getRDFSDatatypeByURI(XSDDatatype.XSDdateTime.getURI()));
    }

    public Object editValue(Component component, RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        JFormattedTextField jFormattedTextField = new JFormattedTextField(simpleDateFormat);
        try {
            Date date = XMLSchemaDatatypes.getDate(object.toString());
            jFormattedTextField.setValue(date);
            JCalendar jCalendar = new JCalendar(date);
            String string = rDFProperty.getBrowserText();
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("Center", (Component)new LabeledComponent("Date", (Component)jCalendar));
            jPanel.add("South", (Component)new LabeledComponent("Time", (Component)jFormattedTextField));
            int n = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(rDFProperty.getProject()), jPanel, "Edit " + rDFProperty.getBrowserText(), 11);
            if (n == 1) {
                Date date2 = jCalendar.getDate();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date2);
                int n2 = gregorianCalendar.get(1);
                int n3 = gregorianCalendar.get(2);
                int n4 = gregorianCalendar.get(5);
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTime((Date)jFormattedTextField.getValue());
                int n5 = gregorianCalendar2.get(11);
                int n6 = gregorianCalendar2.get(12);
                int n7 = gregorianCalendar2.get(13);
                GregorianCalendar gregorianCalendar3 = new GregorianCalendar(n2, n3, n4, n5, n6, n7);
                String string2 = XMLSchemaDatatypes.getDateTimeString(gregorianCalendar3.getTime());
                return this.createRDFSLiteral(rDFProperty.getOWLModel(), string2);
            }
            return null;
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public boolean mustEdit(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.canEdit(rDFResource, rDFProperty, object);
    }
}

