/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.SelectInstancesPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SelectResourcesPanel
extends SelectInstancesPanel {
    private static final String DIRECT_ASSERTED = "Direct Asserted Instances";
    private static final String DIRECT_INFERRED = "Direct Inferred Instances";
    private static final String ALL_ASSERTED = "All Asserted Instances";
    private static final String ALL_INFERRED = "All Inferred Instances";
    private JComboBox classComboBox;
    private JComboBox instancesComboBox;

    public SelectResourcesPanel(OWLModel oWLModel, Collection collection) {
        this(oWLModel, collection, false);
    }

    public SelectResourcesPanel(OWLModel oWLModel, Collection collection, boolean bl) {
        super((KnowledgeBase)oWLModel, collection);
        if (!bl) {
            this._instanceList.setSelectionMode(0);
        }
    }

    protected LabeledComponent createClsesLabeledComponent(KnowledgeBase knowledgeBase, Collection collection) {
        LabeledComponent labeledComponent = super.createClsesLabeledComponent(knowledgeBase, collection);
        return labeledComponent;
    }

    protected JComponent createClsTree(Collection collection) {
        return super.createClsTree(collection);
    }

    protected JComboBox createDirectAllInstanceComboBox() {
        super.createDirectAllInstanceComboBox();
        this.instancesComboBox = ComponentFactory.createComboBox();
        this.instancesComboBox.addItem(DIRECT_ASSERTED);
        this.instancesComboBox.addItem(DIRECT_INFERRED);
        this.instancesComboBox.addItem(ALL_ASSERTED);
        this.instancesComboBox.addItem(ALL_INFERRED);
        this.instancesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectResourcesPanel.this.loadInstances();
            }
        });
        return this.instancesComboBox;
    }

    protected Collection getInstances(Cls cls) {
        Object object = this.instancesComboBox.getSelectedItem();
        if (DIRECT_INFERRED.equals(object)) {
            if (cls instanceof RDFSClass) {
                RDFSClass rDFSClass = (RDFSClass)cls;
                return rDFSClass.getInferredInstances(false);
            }
        } else {
            if (ALL_ASSERTED.equals(object)) {
                return cls.getInstances();
            }
            if (ALL_INFERRED.equals(object) && cls instanceof RDFSClass) {
                RDFSClass rDFSClass = (RDFSClass)cls;
                return rDFSClass.getInferredInstances(true);
            }
        }
        return cls.getDirectInstances();
    }
}

