/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;

public class CreateValueAction
extends ResourceSelectionAction {
    protected TriplesTable table;

    public CreateValueAction(TriplesTable triplesTable) {
        this(triplesTable, "Create new property value...", OWLIcons.getCreateIcon("Triple"));
    }

    public CreateValueAction(TriplesTable triplesTable, String string, Icon icon) {
        super(string, icon);
        this.table = triplesTable;
    }

    protected Collection getAllowedProperties(OWLModel oWLModel) {
        Collection collection = oWLModel.getRDFProperties();
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : collection) {
            if (!rDFProperty.isVisible() || !rDFProperty.hasObjectRange()) continue;
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    public Collection getSelectableResources() {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        Collection collection = this.getAllowedProperties(oWLModel);
        return collection;
    }

    protected void handleCreateAction(RDFProperty rDFProperty) {
        Object object;
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        RDFSClass rDFSClass = null;
        if (rDFProperty.hasObjectRange()) {
            object = rDFProperty.getUnionRangeClasses();
            if (OWLUI.isExternalResourcesSupported(oWLModel)) {
                oWLModel.getRDFUntypedResourcesClass().setVisible(true);
            }
            rDFSClass = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this.table, oWLModel, (Collection)object, "Select class of new value");
            oWLModel.getRDFUntypedResourcesClass().setVisible(false);
        }
        if (rDFSClass != null) {
            Object object2;
            object = rDFSClass.createInstance(null);
            if (object instanceof RDFSClass) {
                object2 = (RDFSClass)object;
                if (object2.getSuperclassCount() == 0) {
                    object2.addSuperclass(oWLModel.getOWLThingClass());
                }
            } else if (object instanceof OWLOntology) {
                object2 = oWLModel.getNamespaceManager().getDefaultNamespace();
                if (((String)object2).endsWith("#")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
                String string = "ontology";
                int n = 0;
                String string2 = string;
                while (oWLModel.getNamespaceManager().getNamespaceForPrefix(string) != null) {
                    string2 = string + n++;
                }
                String string3 = "http://www.owl-ontologies.com/unnamed.owl";
                String string4 = string3 + "#";
                while (oWLModel.getNamespaceManager().getPrefix(string4) != null) {
                    string4 = string3 + n + "#";
                }
                oWLModel.getNamespaceManager().setPrefix(string4, string2);
                OWLOntology oWLOntology = (OWLOntology)object;
                oWLOntology.setName(string2 + ":");
            } else if (object instanceof RDFUntypedResource) {
                OWLUtil.assignUniqueURI((RDFUntypedResource)object);
            }
            oWLModel.getProject().show((Instance)object);
            int n = triplesTableModel.addRow(rDFProperty, object);
            this.table.getSelectionModel().setSelectionInterval(n, n);
            this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        }
    }

    public RDFResource pickResource() {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        Collection collection = this.getSelectableResources();
        return ProtegeUI.getSelectionDialogFactory().selectProperty(this.table, oWLModel, collection);
    }

    public void resourceSelected(RDFResource rDFResource) {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        RDFProperty rDFProperty = (RDFProperty)rDFResource;
        if (rDFProperty instanceof OWLObjectProperty) {
            this.handleCreateAction(rDFProperty);
        } else {
            int n = triplesTableModel.addRow(rDFProperty);
            if (n >= 0) {
                Object object = triplesTableModel.getValue(n);
                Iterator iterator = TriplesComponent.plugins();
                while (iterator.hasNext()) {
                    AnnotationsWidgetPlugin annotationsWidgetPlugin = (AnnotationsWidgetPlugin)iterator.next();
                    if (!annotationsWidgetPlugin.canEdit(triplesTableModel.getSubject(), rDFProperty, object)) continue;
                    Object object2 = annotationsWidgetPlugin.editValue(null, triplesTableModel.getSubject(), rDFProperty, object);
                    if (object2 != null) {
                        triplesTableModel.setValue(object2, n);
                    }
                    return;
                }
                this.table.editCell(n);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(rDFResource.getOWLModel(), "Could not create default value for " + rDFProperty.getBrowserText());
            }
        }
    }
}

