/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;

public class AddResourceAction
extends ResourceSelectionAction {
    private TriplesTable table;

    public AddResourceAction(TriplesTable triplesTable) {
        this(triplesTable, "Add existing resource as value...", OWLIcons.getAddIcon("RDFIndividual"));
    }

    public AddResourceAction(TriplesTable triplesTable, String string, Icon icon) {
        super(string, icon);
        this.table = triplesTable;
    }

    protected Collection getAllowedProperties(OWLModel oWLModel) {
        return oWLModel.getRDFProperties();
    }

    public Collection getSelectableResources() {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        Collection collection = this.getAllowedProperties(oWLModel);
        for (RDFProperty rDFProperty : collection) {
            if (!rDFProperty.isVisible() || !rDFProperty.hasObjectRange() || rDFProperty.isSystem()) continue;
            arrayList.add(rDFProperty);
        }
        arrayList.add(oWLModel.getOWLDisjointWithProperty());
        arrayList.add(oWLModel.getOWLDifferentFromProperty());
        arrayList.add(oWLModel.getOWLEquivalentPropertyProperty());
        arrayList.add(oWLModel.getOWLSameAsProperty());
        arrayList.add(oWLModel.getRDFProperty("rdfs:isDefinedBy"));
        arrayList.add(oWLModel.getRDFProperty("rdfs:seeAlso"));
        return arrayList;
    }

    public void resourceSelected(RDFResource rDFResource) {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        RDFProperty rDFProperty = (RDFProperty)rDFResource;
        if (rDFProperty.hasObjectRange()) {
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
            Set<OWLNamedClass> set = rDFProperty.getUnionRangeClasses();
            if (set.isEmpty()) {
                set = Collections.singleton(oWLModel.getOWLThingClass());
            }
            RDFResource rDFResource2 = ProtegeUI.getSelectionDialogFactory().selectResourceByType(this.table, oWLModel, set);
            oWLModel.getRDFUntypedResourcesClass().setVisible(false);
            this.tryToAddValue(rDFProperty, rDFResource2);
        } else {
            int n = triplesTableModel.addRow(rDFProperty);
            this.table.editCell(n);
        }
    }

    public RDFResource pickResource() {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        Collection collection = this.getSelectableResources();
        return ProtegeUI.getSelectionDialogFactory().selectProperty(this.table, oWLModel, collection);
    }

    private void tryToAddValue(RDFProperty rDFProperty, RDFResource rDFResource) {
        if (rDFResource != null) {
            TriplesTableModel triplesTableModel = this.table.getTableModel();
            if (triplesTableModel.getSubject().getPropertyValues(rDFProperty).contains(rDFResource)) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.table, "This value is already used.");
            } else {
                int n = triplesTableModel.addRow(rDFProperty, rDFResource);
                this.table.getSelectionModel().setSelectionInterval(n, n);
                this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
            }
        }
    }
}

