/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LiteralTableModel
extends AbstractTableModel {
    public static final int COL_VALUE = 0;
    public static final int COL_LANG = 1;
    public static final int COL_TYPE = 1;
    public static final int COL_COUNT = 2;
    private OWLModel owlModel;
    private RDFProperty predicate;
    private Boolean stringProperty = null;
    private RDFResource subject;
    private List values = Collections.EMPTY_LIST;

    public LiteralTableModel(RDFProperty rDFProperty) {
        this.owlModel = rDFProperty.getOWLModel();
        this.predicate = rDFProperty;
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Object.class;
        }
        if (this.isStringProperty()) {
            return String.class;
        }
        return RDFSDatatype.class;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Value";
        }
        if (this.isStringProperty()) {
            return "Lang";
        }
        return "Type";
    }

    protected PropertyValueEditor getEditor(Object object) {
        return PropertyValueEditorManager.getEditor(this.subject, this.predicate, object);
    }

    private Collection getNewValues(int n) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.values.size(); ++i) {
            Object object;
            Object object2 = this.values.get(i);
            if (object2 instanceof RDFSLiteral && (object = ((RDFSLiteral)object2).getPlainValue()) != null) {
                object2 = object;
            }
            if (i != n && (i == n || !this.subject.hasPropertyValue(this.predicate, object2))) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    public Object getObject(int n) {
        return this.values.get(n);
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    private RDFSLiteral getRDFSLiteral(int n) {
        return (RDFSLiteral)this.values.get(n);
    }

    public int getRow(Object object) {
        if (!(object instanceof RDFSLiteral)) {
            object = this.owlModel.createRDFSLiteral(object);
        }
        return this.values.indexOf(object);
    }

    public int getRowCount() {
        return this.values.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            Object object = this.getObject(n);
            if (object instanceof RDFResource) {
                return object;
            }
            RDFSLiteral rDFSLiteral = this.getRDFSLiteral(n);
            return rDFSLiteral.toString();
        }
        if (this.isStringProperty()) {
            RDFSLiteral rDFSLiteral = this.getRDFSLiteral(n);
            return rDFSLiteral.getLanguage();
        }
        Object object = this.getObject(n);
        if (object instanceof RDFResource) {
            return null;
        }
        RDFSLiteral rDFSLiteral = this.getRDFSLiteral(n);
        return rDFSLiteral.getDatatype();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        if (this.getObject(n) instanceof RDFResource) {
            return false;
        }
        RDFSLiteral rDFSLiteral = this.getRDFSLiteral(n);
        Object object = rDFSLiteral.getPlainValue();
        if (object == null) {
            object = rDFSLiteral;
        }
        if (bl = this.owlModel.getTripleStoreModel().isActiveTriple(this.subject, this.predicate, object)) {
            if (n2 == 0) {
                if (bl) {
                    RDFSLiteral rDFSLiteral2 = this.getRDFSLiteral(n);
                    PropertyValueEditor propertyValueEditor = this.getEditor(rDFSLiteral2);
                    return propertyValueEditor == null || !propertyValueEditor.mustEdit(this.subject, this.predicate, rDFSLiteral2);
                }
            } else {
                if (this.isStringProperty()) {
                    return true;
                }
                return !ComponentUtil.isRangeDefined(this.subject, this.predicate);
            }
        }
        return false;
    }

    public boolean isDeleteEnabled(int[] nArray) {
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        boolean bl = false;
        if (nArray.length > 0) {
            bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Object object = this.getObject(n);
                if (tripleStoreModel.isEditableTriple(this.subject, this.predicate, object)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isStringProperty() {
        if (this.stringProperty == null) {
            this.stringProperty = new Boolean(this.isStringPropertyHelper());
        }
        return this.stringProperty;
    }

    private boolean isStringPropertyHelper() {
        RDFSDatatype rDFSDatatype = this.owlModel.getXSDstring();
        if (this.subject != null) {
            Iterator iterator = this.subject.listRDFTypes();
            while (iterator.hasNext()) {
                OWLNamedClass oWLNamedClass;
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                if (!(rDFSClass instanceof OWLNamedClass) || !rDFSDatatype.equals((oWLNamedClass = (OWLNamedClass)rDFSClass).getAllValuesFrom(this.predicate))) continue;
                return true;
            }
        }
        return rDFSDatatype.equals(this.predicate.getRange());
    }

    public void setSubject(RDFResource rDFResource) {
        this.subject = rDFResource;
        this.stringProperty = null;
        this.updateValues();
    }

    private void setTypeAt(Object object, int n) {
        RDFSDatatype rDFSDatatype = (RDFSDatatype)object;
        if (!this.getRDFSLiteral(n).getDatatype().equals(rDFSDatatype)) {
            Object object2;
            String string = "";
            RDFSLiteral rDFSLiteral = this.owlModel.createRDFSLiteral(string, rDFSDatatype);
            PropertyValueEditor propertyValueEditor = this.getEditor(rDFSLiteral);
            if (propertyValueEditor != null && (object2 = propertyValueEditor.createDefaultValue(this.subject, this.predicate)) instanceof RDFSLiteral) {
                rDFSLiteral = (RDFSLiteral)object2;
            }
            this.values.set(n, rDFSLiteral);
            this.subject.setPropertyValues(this.predicate, this.getNewValues(n));
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        RDFSLiteral rDFSLiteral = this.getRDFSLiteral(n);
        if (n2 == 0) {
            if (object instanceof RDFSLiteral) {
                this.values.set(n, object);
            } else {
                String string = (String)object;
                RDFSDatatype rDFSDatatype = rDFSLiteral.getDatatype();
                RDFSLiteral rDFSLiteral2 = this.owlModel.createRDFSLiteral(string, rDFSDatatype);
                this.values.set(n, rDFSLiteral2);
            }
            this.subject.setPropertyValues(this.predicate, this.getNewValues(n));
        } else if (this.isStringProperty()) {
            this.setLangAt((String)object, n);
        } else {
            this.setTypeAt(object, n);
        }
    }

    private void setLangAt(String string, int n) {
        String string2 = (String)this.getValueAt(n, 0);
        Object object = (string = string.trim()).length() == 0 ? string2 : this.owlModel.createRDFSLiteral(string2, string);
        this.values.set(n, object);
        this.subject.setPropertyValues(this.predicate, this.getNewValues(n));
    }

    public void setValues(Collection collection) {
        this.values = new ArrayList();
        for (Object object : collection) {
            if (!(object instanceof RDFResource) && !(object instanceof RDFSLiteral)) {
                object = this.owlModel.createRDFSLiteral(object);
            }
            this.values.add(object);
        }
        this.fireTableDataChanged();
    }

    public void updateValues() {
        if (this.predicate != null && this.subject != null) {
            ArrayList arrayList = new ArrayList(this.subject.getPropertyValues(this.predicate, true));
            Collection collection = this.subject.getHasValuesOnTypes(this.predicate);
            for (Object e : collection) {
                if (arrayList.contains(e)) continue;
                arrayList.add(e);
            }
            this.setValues(arrayList);
        }
    }
}

