/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultAnnotations {
    public static final String SETTINGS_MAP_KEY = DefaultAnnotations.class.getName();
    private OWLModel owlModel;

    public DefaultAnnotations(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    public void addDefaultAnnotationProperty(RDFProperty rDFProperty) {
        this.getSettingsMap().setBoolean(rDFProperty.getName(), true);
    }

    public Collection getDefaultAnnotationProperties() {
        SettingsMap settingsMap = this.getSettingsMap();
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        Iterator iterator = settingsMap.listKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RDFResource rDFResource = this.owlModel.getRDFResource(string);
            if (!(rDFResource instanceof RDFProperty)) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    private SettingsMap getSettingsMap() {
        return this.owlModel.getOWLProject().getSettingsMap().getSettingsMap(SETTINGS_MAP_KEY);
    }

    public void removeDefaultAnnotationProperty(RDFProperty rDFProperty) {
        this.getSettingsMap().remove(rDFProperty.getName());
    }

    public void setDefaultAnnotationProperties(Collection collection) {
        this.owlModel.getOWLProject().getSettingsMap().remove(SETTINGS_MAP_KEY);
        SettingsMap settingsMap = this.getSettingsMap();
        for (RDFProperty rDFProperty : collection) {
            settingsMap.setBoolean(rDFProperty.getName(), true);
        }
    }
}

