/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsLangEditor;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsValueEditor;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsValueRenderer;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class AnnotationsTable
extends TriplesTable {
    private static HashSet singleLineProperties = new HashSet();

    public AnnotationsTable(Project project, AnnotationsTableModel annotationsTableModel) {
        super(project, annotationsTableModel, "annotation");
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        AnnotationsValueRenderer annotationsValueRenderer = new AnnotationsValueRenderer();
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        tableColumn.setCellRenderer(annotationsValueRenderer);
        tableColumn.setCellEditor(new AnnotationsValueEditor(oWLModel, this));
        tableColumn.setPreferredWidth(800);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(annotationsValueRenderer);
        tableColumn2.setPreferredWidth(200);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(this.getColumnCount() - 1);
        tableColumn3.setCellRenderer(annotationsValueRenderer);
        tableColumn3.setCellEditor(new AnnotationsLangEditor(oWLModel, this));
        this.setRowHeight(new JTextField().getPreferredSize().height);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    public static Collection getSingleLineProperties() {
        return Collections.unmodifiableCollection(singleLineProperties);
    }

    public static boolean isMultiLineProperty(RDFProperty rDFProperty) {
        return !singleLineProperties.contains(rDFProperty.getName());
    }

    static {
        singleLineProperties.add("rdfs:seeAlso");
        singleLineProperties.add("rdfs:label");
    }
}

