/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AddTodoAction;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTable;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.CreateValueAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;

public class AnnotationsComponent
extends AbstractTriplesComponent {
    private Action deleteRowAction;

    public AnnotationsComponent(RDFProperty rDFProperty) {
        super(rDFProperty, "Annotations", OWLIcons.getImageIcon("AnnotationsTable"));
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton((Action)new CreateValueAction(this.getTable(), "Create new annotation value", OWLIcons.getCreateIcon("Annotation")){

            public Collection getSelectableResources() {
                TriplesTableModel triplesTableModel = this.table.getTableModel();
                OWLModel oWLModel = triplesTableModel.getOWLModel();
                ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                Collection collection = oWLModel.getOWLAnnotationProperties();
                Collection collection2 = oWLModel.getOWLOntologyProperties();
                RDFResource rDFResource = triplesTableModel.getSubject();
                for (RDFProperty rDFProperty : collection) {
                    if (collection2.contains(rDFProperty)) {
                        if (!(rDFResource instanceof OWLOntology)) continue;
                        arrayList.add(rDFProperty);
                        continue;
                    }
                    RDFSClass rDFSClass = rDFResource.getProtegeType();
                    Collection collection3 = rDFSClass.getUnionDomainProperties(true);
                    if (!collection3.contains(rDFProperty)) continue;
                    boolean bl = rDFResource.getPropertyValues(rDFProperty, true).isEmpty();
                    if (rDFProperty.isFunctional() && !bl) continue;
                    arrayList.add(rDFProperty);
                }
                return arrayList;
            }
        });
        labeledComponent.addHeaderButton((Action)new AddTodoAction((AnnotationsTable)this.getTable()));
        labeledComponent.addHeaderButton((Action)new AddResourceAction(this.getTable()){

            protected Collection getAllowedProperties(OWLModel oWLModel) {
                return oWLModel.getOWLAnnotationProperties();
            }
        });
        this.deleteRowAction = new DeleteTripleAction(this.getTable(), "Delete selected annotation", OWLIcons.getDeleteIcon("Annotation"));
        this.deleteRowAction.setEnabled(false);
        labeledComponent.addHeaderButton(this.deleteRowAction);
    }

    protected TriplesTable createTable(Project project) {
        return new AnnotationsTable(project, (AnnotationsTableModel)this.getTableModel());
    }

    protected TriplesTableModel createTableModel() {
        return new AnnotationsTableModel();
    }

    protected void updateActions() {
        super.updateActions();
        int n = this.getTable().getSelectedRow();
        TriplesTableModel triplesTableModel = this.getTable().getTableModel();
        boolean bl = false;
        if (n >= 0) {
            bl = triplesTableModel.isDeleteEnabled(n);
        }
        this.deleteRowAction.setEnabled(bl);
    }
}

