/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class AddTodoAction
extends AbstractAction {
    private TriplesTable table;

    public AddTodoAction(TriplesTable triplesTable) {
        super("Add TODO list item", OWLIcons.getCreateIcon("TodoAnnotation"));
        this.table = triplesTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TriplesTableModel triplesTableModel = this.table.getTableModel();
        OWLModel oWLModel = triplesTableModel.getOWLModel();
        OWLDatatypeProperty oWLDatatypeProperty = oWLModel.getTodoAnnotationProperty();
        String string = oWLModel.getTodoAnnotationPrefix();
        String string2 = string + ": ";
        Collection collection = triplesTableModel.getSubject().getPropertyValues(oWLDatatypeProperty);
        while (collection.contains(string2)) {
            string2 = string2 + "-";
        }
        triplesTableModel.getSubject().addPropertyValue(oWLDatatypeProperty, string2);
        int n = triplesTableModel.getPropertyValueRow(oWLDatatypeProperty, string2);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.editCell(n);
    }
}

