/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class SymbolEditorComponent
extends JComponent
implements SymbolEditor {
    private SymbolEditorHandler symbolEditorHandler;
    private boolean multiline;
    private SymbolErrorDisplay errorDisplay;
    private OWLModel model;
    private Exception parseException;

    public SymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay, boolean bl) {
        this.model = oWLModel;
        this.errorDisplay = symbolErrorDisplay;
        this.multiline = bl;
    }

    public abstract JTextComponent getTextComponent();

    protected abstract void parseExpression() throws Exception;

    public void assignExpression() {
        try {
            this.parseExpression();
            if (this.getSymbolEditorHandler() != null) {
                this.getSymbolEditorHandler().stopEditing();
            }
        }
        catch (Exception exception) {
            this.parseException = exception;
            this.displayError();
        }
    }

    public void displayError() {
        if (this.parseException != null) {
            try {
                this.parseExpression();
            }
            catch (Exception exception) {
                this.parseException = exception;
            }
        }
        this.errorDisplay.displayError(this.parseException);
    }

    public void setSymbolEditorHandler(SymbolEditorHandler symbolEditorHandler) {
        this.symbolEditorHandler = symbolEditorHandler;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public SymbolEditorHandler getSymbolEditorHandler() {
        return this.symbolEditorHandler;
    }

    public SymbolErrorDisplay getErrorDisplay() {
        return this.errorDisplay;
    }

    public OWLModel getModel() {
        return this.model;
    }

    public void cancelEditing() {
        this.getSymbolEditorHandler().cancelEditing();
    }

    public void backspace() {
        int n = this.getTextComponent().getCaretPosition();
        if (n > 0) {
            Document document = this.getTextComponent().getDocument();
            try {
                document.remove(n - 1, 1);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    public void insertText(String string) {
        this.insertText(string, 0);
    }

    public void insertText(String string, int n) {
        JTextComponent jTextComponent = this.getTextComponent();
        try {
            Document document = jTextComponent.getDocument();
            int n2 = jTextComponent.getCaretPosition();
            document.insertString(n2, string, null);
            jTextComponent.setCaretPosition(n2 + n);
        }
        catch (BadLocationException badLocationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
        }
    }
}

