/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextArea;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OWLTextAreaPanel
extends JPanel
implements ModalDialogFactory.CloseCallback {
    private OWLModel owlModel;
    private OWLSymbolPanel symbolPanel;
    private OWLTextArea textArea;

    OWLTextAreaPanel(OWLModel oWLModel, RDFSClass rDFSClass) {
        this.owlModel = oWLModel;
        this.symbolPanel = new OWLSymbolPanel(oWLModel, false);
        this.textArea = new OWLTextArea(oWLModel, this.symbolPanel){

            protected void checkExpression(String string) throws Throwable {
                OWLTextAreaPanel.this.owlModel.getOWLClassDisplay().getParser().checkClass(OWLTextAreaPanel.this.owlModel, string);
            }
        };
        this.textArea.setPreferredSize(new Dimension(600, 300));
        if (rDFSClass != null) {
            this.textArea.setText(rDFSClass);
        }
        this.symbolPanel.setSymbolEditor(this.textArea);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.textArea));
        this.add("South", this.symbolPanel);
    }

    public boolean canClose(int n) {
        if (n == 1) {
            String string = this.textArea.getText();
            if (string.length() == 0) {
                return false;
            }
            try {
                this.owlModel.getOWLClassDisplay().getParser().checkClass(this.owlModel, string);
                return true;
            }
            catch (Throwable throwable) {
                this.symbolPanel.displayError(throwable);
                return false;
            }
        }
        return true;
    }

    String getResultAsString() {
        return this.textArea.getText();
    }

    public static String showEditDialog(Component component, OWLModel oWLModel, RDFSClass rDFSClass) {
        OWLTextAreaPanel oWLTextAreaPanel = new OWLTextAreaPanel(oWLModel, rDFSClass);
        String string = "Edit OWL Expression";
        if (ProtegeUI.getModalDialogFactory().showDialog(component, oWLTextAreaPanel, string, 11, oWLTextAreaPanel) == 1) {
            return oWLTextAreaPanel.getResultAsString();
        }
        return null;
    }
}

