/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableColumns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RDFPropertiesTableModel
extends AbstractTableModel
implements Disposable,
RDFPropertiesTableColumns {
    private RDFSNamedClass cls;
    private ClassListener classListener = new ClassAdapter(){

        public void addedToUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            rDFProperty.addPropertyValueListener(RDFPropertiesTableModel.this.valueListener);
            RDFPropertiesTableModel.this.listenedToProperties.add(rDFProperty);
            RDFPropertiesTableModel.this.refill();
        }

        public void removedFromUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            rDFProperty.removePropertyValueListener(RDFPropertiesTableModel.this.valueListener);
            RDFPropertiesTableModel.this.listenedToProperties.remove(rDFProperty);
            RDFPropertiesTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            RDFPropertiesTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            RDFPropertiesTableModel.this.refill();
        }
    };
    private int directCount = 0;
    private Collection listenedToProperties = new HashSet();
    private List properties = new ArrayList();
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            int n = RDFPropertiesTableModel.this.getRow(rDFProperty);
            RDFPropertiesTableModel.this.fireTableCellUpdated(n, 1);
            RDFPropertiesTableModel.this.fireTableCellUpdated(n, 0);
            RDFPropertiesTableModel.this.fireTableCellUpdated(n, 2);
        }
    };

    public void dispose() {
        this.unregisterValueListener();
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
    }

    private void fill() {
        ArrayList arrayList = new ArrayList(this.cls.getUnionDomainProperties());
        Collections.sort(arrayList, new ResourceComparator());
        this.properties.addAll(arrayList);
        this.directCount = this.properties.size();
        ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : this.cls.getUnionDomainProperties(true)) {
            if (rDFProperty.isSystem() || arrayList.contains(rDFProperty)) continue;
            arrayList2.add(rDFProperty);
        }
        Collections.sort(arrayList2, new ResourceComparator());
        this.properties.addAll(arrayList2);
        this.fireTableRowsInserted(0, this.getRowCount());
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        if (n == 0 || n == 2) {
            return RDFResource.class;
        }
        return super.getColumnClass(n);
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Property";
        }
        if (n == 1) {
            return "Cardinality";
        }
        if (n == 2) {
            return "Type";
        }
        return super.getColumnName(n);
    }

    public RDFProperty getRDFProperty(int n) {
        return (RDFProperty)this.properties.get(n);
    }

    public int getRow(RDFProperty rDFProperty) {
        return this.properties.indexOf(rDFProperty);
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public Object getValueAt(int n, int n2) {
        RDFProperty rDFProperty = this.getRDFProperty(n);
        if (n2 == 0) {
            return rDFProperty;
        }
        if (n2 == 1) {
            return rDFProperty.isFunctional() ? "Single" : "Multiple";
        }
        if (n2 == 2) {
            return rDFProperty.getRange();
        }
        return null;
    }

    public boolean isDirectProperty(int n) {
        return n < this.directCount;
    }

    private void refill() {
        int n = this.getRowCount();
        this.properties.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        this.fill();
    }

    public void setClass(RDFSNamedClass rDFSNamedClass) {
        this.unregisterValueListener();
        if (this.cls != null) {
            rDFSNamedClass.removeClassListener(this.classListener);
        }
        this.cls = rDFSNamedClass;
        if (rDFSNamedClass != null) {
            rDFSNamedClass.addClassListener(this.classListener);
        }
        this.refill();
    }

    private void unregisterValueListener() {
        for (RDFProperty rDFProperty : this.listenedToProperties) {
            rDFProperty.removePropertyValueListener(this.valueListener);
        }
    }
}

