/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OldRestrictionTreeNode
extends RestrictionTreeNode {
    private RDFSClass inheritedFromClass;
    private PropertyRestrictionsTree tree;

    public OldRestrictionTreeNode(PropertyRestrictionsTree propertyRestrictionsTree, OWLRestriction oWLRestriction, RDFSClass rDFSClass) {
        this.inheritedFromClass = rDFSClass;
        this.tree = propertyRestrictionsTree;
        this.setUserObject(oWLRestriction);
    }

    public void checkExpression(String string) throws Throwable {
        this.getRestriction().checkFillerText(string);
    }

    public String getFillerText() {
        return this.getRestriction().getFillerText();
    }

    public RDFSClass getInheritedFromClass() {
        return this.inheritedFromClass;
    }

    public char getOperator() {
        return this.getRestriction().getOperator();
    }

    public OWLRestriction getRestriction() {
        return (OWLRestriction)this.getUserObject();
    }

    public Cls getRestrictionMetaCls() {
        return this.getRestriction().getProtegeType();
    }

    public Icon getIcon() {
        OWLRestriction oWLRestriction = this.getRestriction();
        Icon icon = ProtegeUI.getIcon(oWLRestriction);
        if (this.inheritedFromClass == null) {
            return icon;
        }
        if (icon instanceof ImageIcon) {
            return OWLIcons.getInheritedClsIcon((ImageIcon)icon);
        }
        return icon;
    }

    public boolean isInherited() {
        return this.inheritedFromClass != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserObject(Object object) {
        if (object instanceof String) {
            if (this.getRestriction().isIncluded()) {
                return;
            }
            String string = (String)object;
            OWLModel oWLModel = this.getRestriction().getOWLModel();
            try {
                this.getRestriction().checkFillerText(string);
                try {
                    oWLModel.beginTransaction("Change restriction filler of " + this.getRestriction().getBrowserText() + " to " + string);
                    this.getRestriction().setFillerText(string);
                }
                catch (Exception exception) {
                    OWLUI.handleError(oWLModel, exception);
                }
                finally {
                    oWLModel.endTransaction();
                }
                this.updateConditionsWidget();
            }
            catch (Exception exception) {
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Illegal restriction filler: " + string);
            }
        } else {
            super.setUserObject(object);
        }
    }

    private void updateConditionsWidget() {
        ConditionsWidget conditionsWidget;
        Container container;
        for (container = this.tree.getParent(); container != null && !(container instanceof InstanceDisplay); container = container.getParent()) {
        }
        if (container instanceof InstanceDisplay && (conditionsWidget = (ConditionsWidget)((Object)OWLUI.searchComponentOfType(container, ConditionsWidget.class))) != null) {
            conditionsWidget.repaint();
        }
    }
}

