/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class AddPropertyAction
extends ResourceSelectionAction {
    private PropertyWidget propertyWidget;

    public AddPropertyAction(PropertyWidget propertyWidget) {
        super("Add this class to the domain of properties...", OWLIcons.getAddIcon("RDFProperty"), true);
        this.propertyWidget = propertyWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceSelected(RDFResource rDFResource) {
        RDFSClass rDFSClass = (RDFSClass)this.propertyWidget.getEditedResource();
        RDFProperty rDFProperty = (RDFProperty)rDFResource;
        OWLNamedClass oWLNamedClass = rDFSClass.getOWLModel().getOWLThingClass();
        OWLModel oWLModel = rDFResource.getOWLModel();
        try {
            oWLModel.beginTransaction("Add " + rDFSClass.getBrowserText() + " to the domain of " + rDFProperty.getBrowserText());
            if (rDFProperty.getUnionDomain(false).contains(oWLNamedClass)) {
                rDFProperty.removeUnionDomainClass(oWLNamedClass);
            }
            rDFProperty.addUnionDomainClass(rDFSClass);
            rDFProperty.synchronizeDomainAndRangeOfInverse();
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
        }
        finally {
            oWLModel.endTransaction();
        }
    }

    protected RDFSNamedClass getBasePropertyMetaclass() {
        OWLModel oWLModel = (OWLModel)this.propertyWidget.getKnowledgeBase();
        return oWLModel.getRDFPropertyClass();
    }

    public Collection getSelectableResources() {
        RDFSNamedClass rDFSNamedClass = this.getBasePropertyMetaclass();
        ArrayList arrayList = new ArrayList(rDFSNamedClass.getInstances(true));
        RDFSClass rDFSClass = (RDFSClass)this.propertyWidget.getEditedResource();
        arrayList.removeAll(rDFSClass.getUnionDomainProperties());
        ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : arrayList) {
            if (rDFProperty instanceof OWLProperty && rDFProperty.isAnnotationProperty() || !rDFProperty.isEditable()) continue;
            arrayList2.add(rDFProperty);
        }
        return arrayList2;
    }

    public Collection pickResources() {
        String string = "Select " + this.propertyWidget.getLabel();
        OWLModel oWLModel = (OWLModel)this.propertyWidget.getKnowledgeBase();
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection((Component)((Object)this.propertyWidget), oWLModel, this.getSelectableResources(), string);
    }
}

