/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class CreateSiblingClassAction
extends ResourceAction {
    public static final String TEXT = "Create sibling class";

    public CreateSiblingClassAction() {
        super(TEXT, OWLIcons.getCreateIcon("SiblingClass"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
        CreateSiblingClassAction.performAction(rDFSNamedClass, classTreePanel);
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof OWLSubclassPane && rDFResource instanceof RDFSNamedClass && !rDFResource.equals(rDFResource.getOWLModel().getOWLThingClass());
    }

    public static void performAction(RDFSNamedClass rDFSNamedClass, ClassTreePanel classTreePanel) {
        Collection collection = rDFSNamedClass.getNamedSuperclasses();
        if (!collection.isEmpty()) {
            RDFSNamedClass rDFSNamedClass2;
            OWLModel oWLModel = rDFSNamedClass.getOWLModel();
            oWLModel.beginTransaction("Create sibling of class " + rDFSNamedClass.getBrowserText());
            String string = oWLModel.createNewResourceName("Class");
            RDFSClass rDFSClass = rDFSNamedClass.getRDFType();
            if (rDFSClass == null) {
                rDFSClass = rDFSNamedClass.getProtegeType();
            }
            if ((rDFSNamedClass2 = oWLModel.createRDFSNamedClass(string, collection, rDFSClass)) instanceof OWLNamedClass) {
                for (RDFSNamedClass rDFSNamedClass3 : collection) {
                    ((OWLNamedClass)rDFSNamedClass2).addInferredSuperclass(rDFSNamedClass3);
                }
            }
            oWLModel.endTransaction();
            classTreePanel.setSelectedClass(rDFSNamedClass2);
        }
    }
}

