/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class PropertyFormTableModel
extends AbstractTableModel
implements Disposable,
SymbolTableModel {
    public static final int COL_FILLER = 0;
    private List rows = new ArrayList();
    private List restrictions = new ArrayList();
    private RDFSClass definition;
    private ClassListener listener = new ClassAdapter(){

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyFormTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyFormTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyFormTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertyFormTableModel.this.refill();
        }
    };
    private OWLNamedClass namedClass;
    private RDFProperty property;

    public PropertyFormTableModel(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty) {
        this(oWLNamedClass, rDFProperty, null);
    }

    public PropertyFormTableModel(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, RDFSClass rDFSClass) {
        this.namedClass = oWLNamedClass;
        this.property = rDFProperty;
        this.definition = rDFSClass;
        oWLNamedClass.addClassListener(this.listener);
        this.addRows();
    }

    private void addRows() {
        assert (this.rows.isEmpty());
        Iterator iterator = this.listRestrictions();
        while (iterator.hasNext()) {
            Object object;
            OWLExistentialRestriction oWLExistentialRestriction;
            OWLRestriction oWLRestriction = (OWLRestriction)iterator.next();
            if (oWLRestriction instanceof OWLSomeValuesFrom) {
                oWLExistentialRestriction = (OWLSomeValuesFrom)oWLRestriction;
                object = oWLExistentialRestriction.getFiller();
                if (!(object instanceof RDFSClass)) continue;
                this.rows.add(object);
                this.restrictions.add(oWLExistentialRestriction);
                continue;
            }
            if (!(oWLRestriction instanceof OWLHasValue) || !((object = (oWLExistentialRestriction = (OWLHasValue)oWLRestriction).getHasValue()) instanceof RDFResource)) continue;
            this.rows.add(object);
            this.restrictions.add(oWLExistentialRestriction);
        }
        Collections.sort(this.rows, new Comparator(){

            public int compare(Object object, Object object2) {
                RDFResource rDFResource = (RDFResource)object;
                RDFResource rDFResource2 = (RDFResource)object2;
                if (!(rDFResource instanceof OWLAnonymousClass)) {
                    if (rDFResource2 instanceof OWLAnonymousClass) {
                        return -1;
                    }
                } else if (!(rDFResource2 instanceof OWLAnonymousClass)) {
                    return 1;
                }
                return rDFResource.getBrowserText().compareTo(rDFResource2.getBrowserText());
            }
        });
        this.fireTableRowsInserted(0, this.getRowCount() - 1);
    }

    public void dispose() {
        this.namedClass.removeClassListener(this.listener);
    }

    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        throw new IllegalArgumentException("Unknown column index " + n);
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public OWLNamedClass getNamedClass() {
        return this.namedClass;
    }

    public RDFProperty getPredicate(int n) {
        return null;
    }

    public RDFProperty getProperty() {
        return this.property;
    }

    public RDFResource getRDFResource(int n) {
        return (RDFResource)this.rows.get(n);
    }

    public RDFResource getSubject() {
        return null;
    }

    public List getRDFResources() {
        return new ArrayList(this.rows);
    }

    public OWLExistentialRestriction getRestriction(int n) {
        return (OWLExistentialRestriction)this.restrictions.get(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getRDFResource(n).getBrowserText();
        }
        throw new IllegalArgumentException("Unknown column index " + n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    private Iterator listRestrictions() {
        return this.namedClass.getRestrictions(this.property, true).iterator();
    }

    private void refill() {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this.restrictions.clear();
        this.rows.clear();
        this.addRows();
        this.fireTableDataChanged();
    }
}

