/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToDefinedClassAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MinCardiZeroTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    private static boolean warn = true;
    private static boolean fix = false;

    public String getDocumentation() {
        return "Find classes that have a min cardi zero restriction on them";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Min Cardi Zero";
    }

    public List test(RDFSClass rDFSClass) {
        if (rDFSClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSClass;
            Collection collection = oWLNamedClass.getRestrictions();
            for (OWLRestriction oWLRestriction : collection) {
                if (!(oWLRestriction instanceof OWLMinCardinality) || ((OWLMinCardinality)oWLRestriction).getCardinality() != 0) continue;
                return Collections.singletonList(new DefaultOWLTestResult("Min cardinality zero does not mean anything in OWL", rDFSClass, 2, this));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        boolean bl = false;
        this.handleUserWarning();
        if (fix) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)oWLTestResult.getHost();
            OWLModel oWLModel = oWLNamedClass.getOWLModel();
            Collection collection = oWLNamedClass.getRestrictions();
            for (OWLRestriction oWLRestriction : collection) {
                if (!(oWLRestriction instanceof OWLMinCardinality) || ((OWLMinCardinality)oWLRestriction).getCardinality() != 0) continue;
                OWLMinCardinality oWLMinCardinality = (OWLMinCardinality)oWLRestriction.createClone();
                oWLMinCardinality.setCardinality(1);
                String string = oWLNamedClass.getBrowserText() + "That" + oWLMinCardinality.getOnProperty().getBrowserText();
                if (oWLMinCardinality.getQualifier() != null) {
                    string = string + oWLMinCardinality.getQualifier().getBrowserText();
                }
                OWLNamedClass oWLNamedClass2 = oWLModel.createOWLNamedClass(string);
                oWLNamedClass2.addSuperclass(oWLNamedClass);
                oWLNamedClass2.removeSuperclass(oWLModel.getOWLThingClass());
                oWLNamedClass2.addSuperclass(oWLMinCardinality);
                ConvertToDefinedClassAction.performAction(oWLNamedClass2);
                oWLNamedClass.removeSuperclass(oWLRestriction);
                bl = true;
            }
        }
        return bl;
    }

    private void handleUserWarning() {
        if (warn) {
            JPanel jPanel = new JPanel(new BorderLayout(6, 6));
            JLabel jLabel = new JLabel("Fixing min cardinality 0 restrictions creates new defined subclasses. Are you sure you want to do this?");
            JCheckBox jCheckBox = new JCheckBox("do not warn me again this session", false);
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)jCheckBox, "South");
            boolean bl = fix = JOptionPane.showConfirmDialog(Application.getMainWindow(), jPanel, "Fix min cardi 0", 0, 2) == 0;
            if (jCheckBox.isSelected()) {
                warn = false;
            }
        }
    }
}

