/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SymmetricPropertyMustHaveEqualRangeAndDomainTest
extends AbstractOWLTest
implements RepairableOWLTest,
RDFPropertyTest {
    public SymmetricPropertyMustHaveEqualRangeAndDomainTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty && ((OWLObjectProperty)rDFProperty).isSymmetric()) {
            Collection collection;
            if (!rDFProperty.isDomainDefined()) {
                return false;
            }
            Collection collection2 = rDFProperty.getUnionDomain();
            return !collection2.containsAll(collection = rDFProperty.getUnionRangeClasses()) || !collection.containsAll(collection2);
        }
        return false;
    }

    private String getListString(Collection collection) {
        String string = "{";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            string = string + instance.getBrowserText();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string + "}";
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        OWLProperty oWLProperty = (OWLProperty)oWLTestResult.getHost();
        Collection collection = oWLProperty.getUnionDomain();
        Collection collection2 = oWLProperty.getUnionRangeClasses();
        String string = "The current range of " + oWLProperty.getBrowserText() + " is " + this.getListString(collection2) + "\nand its current domain is " + this.getListString(collection) + ".\nDo you want to assign the range into the domain (yes)" + "\nor do you want to assign the domain into the range (no)?";
        int n = ProtegeUI.getModalDialogFactory().showConfirmCancelDialog(ProtegeUI.getTopLevelContainer(oWLProperty.getProject()), string, "Repair test failure");
        if (n == 2) {
            SymmetricPropertyMustHaveEqualRangeAndDomainTest.repairRangeIntoDomain(oWLProperty);
            return true;
        }
        if (n == 3) {
            SymmetricPropertyMustHaveEqualRangeAndDomainTest.repairDomainIntoRange(oWLProperty);
            return true;
        }
        return false;
    }

    public static void repairDomainIntoRange(OWLProperty oWLProperty) {
        if (oWLProperty.hasObjectRange()) {
            ArrayList arrayList = new ArrayList(oWLProperty.getUnionDomain());
            oWLProperty.setUnionRangeClasses(arrayList);
        }
    }

    public static void repairRangeIntoDomain(OWLProperty oWLProperty) {
        Collection collection = oWLProperty.getUnionRangeClasses();
        ArrayList arrayList = new ArrayList(oWLProperty.getUnionDomain());
        for (RDFSClass rDFSClass : arrayList) {
            oWLProperty.removeUnionDomainClass(rDFSClass);
        }
        for (RDFSClass rDFSClass : collection) {
            oWLProperty.addUnionDomainClass(rDFSClass);
        }
    }

    public List test(RDFProperty rDFProperty) {
        if (SymmetricPropertyMustHaveEqualRangeAndDomainTest.fails(rDFProperty)) {
            return Collections.singletonList(new DefaultOWLTestResult("Symmetric properties must have equal ranges and domains.", rDFProperty, 1, this));
        }
        return Collections.EMPTY_LIST;
    }
}

