/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SubpropertyRangeMustNarrowTest
extends AbstractOWLTest
implements RDFPropertyTest {
    public SubpropertyRangeMustNarrowTest() {
        super("Sanity Tests", "Range of a subproperty can only narrow superproperty");
    }

    public static OWLObjectProperty fails(OWLObjectProperty oWLObjectProperty) {
        Collection collection = oWLObjectProperty.getSuperproperties(true);
        if (!collection.isEmpty()) {
            OWLNamedClass oWLNamedClass = oWLObjectProperty.getOWLModel().getOWLThingClass();
            Set<OWLNamedClass> set = oWLObjectProperty.getUnionRangeClasses();
            if (set.isEmpty()) {
                set = Collections.singleton(oWLNamedClass);
            }
            for (Slot slot : collection) {
                if (!(slot instanceof OWLObjectProperty)) continue;
                Set<OWLNamedClass> set2 = slot.getAllowedClses();
                if (set2.isEmpty()) {
                    set2 = Collections.singleton(oWLNamedClass);
                }
                if (SubpropertyRangeMustNarrowTest.isSubClasses(set2, set)) continue;
                return (OWLObjectProperty)slot;
            }
        }
        return null;
    }

    private static boolean isSubClasses(Collection collection, Collection collection2) {
        for (Cls cls : collection2) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            boolean bl = false;
            for (Cls cls2 : collection) {
                if (!(cls2 instanceof RDFSNamedClass) || !cls.equals(cls2) && !cls.hasSuperclass(cls2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List test(RDFProperty rDFProperty) {
        OWLObjectProperty oWLObjectProperty;
        if (rDFProperty instanceof OWLObjectProperty && (oWLObjectProperty = SubpropertyRangeMustNarrowTest.fails((OWLObjectProperty)rDFProperty)) != null) {
            return Collections.singletonList(new DefaultOWLTestResult("The range of " + rDFProperty.getBrowserText() + " is not a subset of the range of its superproperty " + oWLObjectProperty.getBrowserText() + ".", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

