/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PropertyDomainRedundancyTest
extends AbstractOWLTest
implements RDFPropertyTest,
RepairableOWLTest {
    public PropertyDomainRedundancyTest() {
        super("Sanity Tests", "Domain of a property should not contain redundant classes");
    }

    public static Collection fails(OWLObjectProperty oWLObjectProperty) {
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        HashSet hashSet2 = new HashSet(oWLObjectProperty.getUnionDomain());
        if (hashSet2.size() >= 2) {
            for (RDFSClass rDFSClass : hashSet2) {
                for (RDFSClass rDFSClass2 : hashSet2) {
                    if (rDFSClass2.equals(rDFSClass) || !rDFSClass.getSuperclasses(true).contains(rDFSClass2)) continue;
                    hashSet.add(rDFSClass);
                }
            }
        }
        return hashSet;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        RDFResource rDFResource = oWLTestResult.getHost();
        if (rDFResource instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFResource;
            Collection collection = PropertyDomainRedundancyTest.fails(oWLObjectProperty);
            for (RDFSClass rDFSClass : collection) {
                oWLObjectProperty.removeUnionDomainClass(rDFSClass);
            }
            return PropertyDomainRedundancyTest.fails(oWLObjectProperty).isEmpty();
        }
        return false;
    }

    public List test(RDFProperty rDFProperty) {
        Collection collection;
        if (rDFProperty instanceof OWLObjectProperty && !(collection = PropertyDomainRedundancyTest.fails((OWLObjectProperty)rDFProperty)).isEmpty()) {
            String string = collection.size() > 1 ? "es " : " ";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                string = string + rDFSClass.getBrowserText();
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            return Collections.singletonList(new DefaultOWLTestResult("The domain of " + rDFProperty.getBrowserText() + " contains the redundant class" + string + ".", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

