/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.constraints;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLResultsPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SPARQLAssertTest
extends AbstractOWLTest
implements RDFSClassTest,
RepairableOWLTest {
    public static final String PREFIX = "assert";
    public static final String URI = "http://www.owl-ontologies.com/assert.owl";
    public static final String NAMESPACE = "http://www.owl-ontologies.com/assert.owl#";
    public static final String EMPTY_PROPERTY_URI = "http://www.owl-ontologies.com/assert.owl#empty";
    public static final String NOT_EMPTY_PROPERTY_URI = "http://www.owl-ontologies.com/assert.owl#notEmpty";

    public SPARQLAssertTest() {
        super("Constraints", "SPARQL Asserts");
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        SPARQLResultsPanel sPARQLResultsPanel = SPARQLOWLModelAction.show(oWLTestResult.getHost().getOWLModel(), true);
        String string = (String)oWLTestResult.getUserObject();
        sPARQLResultsPanel.setQueryText(string);
        sPARQLResultsPanel.executeQuery(string);
        return false;
    }

    public List test(RDFSClass rDFSClass) {
        RDFProperty rDFProperty;
        OWLModel oWLModel = rDFSClass.getOWLModel();
        String string = oWLModel.getResourceNameForURI(NOT_EMPTY_PROPERTY_URI);
        if (string != null && (rDFProperty = oWLModel.getRDFProperty(string)) != null) {
            ArrayList arrayList = new ArrayList();
            this.test(rDFSClass, rDFProperty, true, "at least one match", "AssertTrue", arrayList);
            String string2 = oWLModel.getResourceNameForURI(EMPTY_PROPERTY_URI);
            RDFProperty rDFProperty2 = oWLModel.getRDFProperty(string2);
            if (rDFProperty2 != null) {
                this.test(rDFSClass, rDFProperty2, false, "no matches", "AssertFalse", arrayList);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private void test(RDFSClass rDFSClass, RDFProperty rDFProperty, boolean bl, String string, String string2, List list) {
        OWLModel oWLModel = rDFSClass.getOWLModel();
        Iterator iterator = rDFSClass.listPropertyValues(rDFProperty);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) continue;
            String string3 = (String)e;
            try {
                QueryResults queryResults = oWLModel.executeSPARQLQuery(string3);
                if (queryResults.hasNext() == bl) continue;
                DefaultOWLTestResult defaultOWLTestResult = new DefaultOWLTestResult("Query asserted to have " + string + ": " + string3, rDFSClass, 1, this, OWLIcons.getImageIcon(string2));
                defaultOWLTestResult.setUserObject(string3);
                list.add(defaultOWLTestResult);
            }
            catch (Exception exception) {
                list.add(new DefaultOWLTestResult("Query could not be executed: " + string3 + ". " + exception.getMessage(), rDFSClass, 2, this));
            }
        }
    }
}

