/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class OWLTestLibrary {
    private static Map testMap = new HashMap();
    private static Set userDefinedClasses = new HashSet();

    public static void addOWLTestClass(Class clazz) {
        userDefinedClasses.add(clazz);
    }

    private static OWLTest createOWLTest(Class clazz) {
        try {
            return (OWLTest)clazz.newInstance();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public static OWLTest getOWLTest(Class clazz) {
        OWLTest oWLTest = (OWLTest)testMap.get(clazz);
        if (oWLTest == null) {
            oWLTest = OWLTestLibrary.createOWLTest(clazz);
            testMap.put(clazz, oWLTest);
        }
        return oWLTest;
    }

    public static Class[] getOWLTestClasses() {
        ArrayList arrayList = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"OWLTest", (String)"True"));
        arrayList.addAll(userDefinedClasses);
        return arrayList.toArray(new Class[0]);
    }

    public static boolean isOWLDLTest(Class clazz) {
        OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
        return oWLTest instanceof OWLDLTest;
    }

    public static void repairRDFPropertyTests(RDFProperty rDFProperty) {
        OWLModel oWLModel = rDFProperty.getOWLModel();
        OWLTest[] oWLTestArray = oWLModel.getOWLTests();
        for (int i = 0; i < oWLTestArray.length; ++i) {
            OWLTest oWLTest = oWLTestArray[i];
            if (!(oWLTest instanceof RDFPropertyTest) || !(oWLTest instanceof AutoRepairableOWLTest)) continue;
            RDFPropertyTest rDFPropertyTest = (RDFPropertyTest)oWLTest;
            OWLTestLibrary.repairOWLSlotTest(rDFPropertyTest, rDFProperty);
        }
    }

    private static void repairOWLSlotTest(RDFPropertyTest rDFPropertyTest, RDFProperty rDFProperty) {
        List list = rDFPropertyTest.test(rDFProperty);
        for (OWLTestResult oWLTestResult : list) {
            ((RepairableOWLTest)((Object)rDFPropertyTest)).repair(oWLTestResult);
        }
    }
}

