/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class SWRLTableModel
extends AbstractTableModel
implements Disposable,
SymbolTableModel {
    public static final int COL_NAME = 0;
    public static final int COL_EXPRESSION = 1;
    public static final int COL_COUNT = 2;
    private ClassListener clsListener = new ClassAdapter(){

        public void instanceAdded(RDFSClass rDFSClass, RDFResource rDFResource) {
            final SWRLImp sWRLImp = (SWRLImp)rDFResource;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWRLTableModel.this.perhapsAdd(sWRLImp);
                }
            });
        }

        public void instanceRemoved(RDFSClass rDFSClass, RDFResource rDFResource) {
            SWRLTableModel.this.perhapsRemove((SWRLImp)rDFResource);
        }
    };
    private List imps = new ArrayList();
    private RDFResource rdfResource;
    private OWLModel owlModel;

    public SWRLTableModel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
        this.imps.addAll(sWRLFactory.getImps());
        this.sortImps();
        this.initClsListener();
    }

    public SWRLTableModel(RDFResource rDFResource) {
        this.rdfResource = rDFResource;
        this.owlModel = rDFResource.getOWLModel();
        this.addReferencingImps(rDFResource);
        this.sortImps();
        this.initClsListener();
    }

    private void addReferencingImps(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
        Collection collection = sWRLFactory.getImps();
        for (SWRLImp sWRLImp : collection) {
            if (!this.isSuitable(sWRLImp)) continue;
            this.imps.add(sWRLImp);
        }
    }

    public void dispose() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").removeClassListener(this.clsListener);
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        if (n == 1) {
            return "Expression";
        }
        return null;
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public SWRLImp getImp(int n) {
        return (SWRLImp)this.imps.get(n);
    }

    public RDFProperty getPredicate(int n) {
        return null;
    }

    public RDFResource getRDFResource(int n) {
        return this.getImp(n);
    }

    public RDFResource getSubject() {
        return null;
    }

    private int getRowFor(SWRLImp sWRLImp) {
        int n;
        String string = sWRLImp.getName();
        for (n = 0; n < this.imps.size() && string.compareToIgnoreCase(this.getImp(n).getName()) >= 0; ++n) {
        }
        return n;
    }

    public int getSymbolColumnIndex() {
        return 1;
    }

    public int getRowCount() {
        return this.imps.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == this.getSymbolColumnIndex()) {
            return this.getImp(n).getBrowserText();
        }
        if (n2 == 0) {
            return this.getImp(n).getName();
        }
        return null;
    }

    public int indexOf(SWRLImp sWRLImp) {
        return this.imps.indexOf(sWRLImp);
    }

    private void initClsListener() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").addClassListener(this.clsListener);
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 || n2 == 1) {
            SWRLImp sWRLImp = this.getImp(n);
            return sWRLImp.isEditable();
        }
        return false;
    }

    private boolean isSuitable(SWRLImp sWRLImp) {
        if (this.rdfResource == null) {
            return true;
        }
        Set set = sWRLImp.getReferencedInstances();
        return set.contains(this.rdfResource);
    }

    private void perhapsAdd(SWRLImp sWRLImp) {
        if (this.isSuitable(sWRLImp)) {
            int n = this.getRowFor(sWRLImp);
            this.imps.add(n, sWRLImp);
            this.fireTableRowsInserted(n, n);
        }
    }

    private void perhapsRemove(SWRLImp sWRLImp) {
        int n = this.imps.indexOf(sWRLImp);
        if (n >= 0) {
            this.imps.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        SWRLImp sWRLImp = this.getImp(n);
        if (n2 == 1) {
            String string = (String)object;
            SWRLParser sWRLParser = new SWRLParser(this.owlModel);
            try {
                sWRLImp.setExpression(string);
                if (!this.isSuitable(sWRLImp)) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "The replacing rule no longer fits the selection\ncriteria of this rules list, and will therefore no\nlonger be visible here.  But no reason to panic: It\nshould still show up on the SWRL tab.");
                }
            }
            catch (Exception exception) {}
        } else if (n2 == 0) {
            String string = (String)object;
            if (this.owlModel.isValidResourceName(string, sWRLImp)) {
                RDFResource rDFResource = this.owlModel.getRDFResource(string);
                if (rDFResource != null) {
                    if (!sWRLImp.equals(rDFResource)) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "The name " + string + " is already used in this ontology.");
                    }
                } else {
                    sWRLImp.setName(string);
                }
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, string + " is not a valid rule name.");
            }
        }
    }

    public void setRowOf(SWRLImp sWRLImp, int n) {
        int n2 = this.imps.indexOf(sWRLImp);
        this.imps.remove(n2);
        this.fireTableRowsDeleted(n2, n2);
        this.imps.add(n, sWRLImp);
        this.fireTableRowsInserted(n, n);
    }

    private void sortImps() {
        Collections.sort(this.imps, new Comparator(){

            public int compare(Object object, Object object2) {
                SWRLImp sWRLImp = (SWRLImp)object;
                SWRLImp sWRLImp2 = (SWRLImp)object2;
                return sWRLImp.getName().compareToIgnoreCase(sWRLImp2.getName());
            }
        });
    }
}

