/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLSymbolEditor;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTableModel;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SWRLTable
extends SymbolTable
implements Disposable {
    public SWRLTable(SWRLTableModel sWRLTableModel, OWLModel oWLModel) {
        super(sWRLTableModel, oWLModel, true, new SWRLSymbolPanel(oWLModel, true, true));
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn2.setPreferredWidth(700);
        this.setDefaultRenderer(SWRLImp.class, (TableCellRenderer)((Object)new ResourceRenderer()));
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new SWRLSymbolEditor(oWLModel, symbolErrorDisplay);
    }

    public void dispose() {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        sWRLTableModel.dispose();
    }

    protected String editMultiLine(RDFResource rDFResource) {
        return null;
    }

    protected Icon getDefaultCellEditorIcon(RDFResource rDFResource) {
        return SWRLIcons.getImpIcon();
    }

    protected Collection getNavigationMenuItems(RDFResource rDFResource) {
        SWRLImp sWRLImp = (SWRLImp)rDFResource;
        Set set = sWRLImp.getReferencedInstances();
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (RDFResource rDFResource2 : set) {
            if (rDFResource2 instanceof SWRLIndividual) continue;
            arrayList.add(rDFResource2);
        }
        return arrayList;
    }

    public SWRLImp getSelectedImp() {
        int n = this.getSelectedRow();
        if (n >= 0 && n < this.getModel().getRowCount()) {
            return (SWRLImp)this.getSymbolTableModel().getRDFResource(n);
        }
        return null;
    }

    protected String getToolTipText(RDFResource rDFResource) {
        if (rDFResource instanceof SWRLImp) {
            OWLDatatypeProperty oWLDatatypeProperty = this.getOWLModel().getRDFSCommentProperty();
            Object object = rDFResource.getPropertyValue(oWLDatatypeProperty);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof RDFSLiteral) {
                return ((RDFSLiteral)object).toString();
            }
            return null;
        }
        return null;
    }

    public void replaceImp(SWRLImp sWRLImp, SWRLImp sWRLImp2) {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        int n = sWRLTableModel.indexOf(sWRLImp);
        if (sWRLTableModel.indexOf(sWRLImp2) >= 0) {
            sWRLTableModel.setRowOf(sWRLImp2, n);
            this.setSelectedRow(n);
        }
        sWRLImp.deleteImp();
    }

    public void setSelectedRow(RDFResource rDFResource) {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        int n = sWRLTableModel.indexOf((SWRLImp)rDFResource);
        this.setSelectedRow(n);
    }
}

