/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class DefaultSWRLImp
extends DefaultOWLIndividual
implements SWRLImp {
    public DefaultSWRLImp(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultSWRLImp() {
    }

    public SWRLImp createClone() {
        String string = this.getBrowserText();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        SWRLParser sWRLParser = new SWRLParser(oWLModel);
        sWRLParser.setParseOnly(false);
        try {
            return sWRLParser.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void deleteHeadAndBody() {
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-INSTANCES");
        Set set = this.getReferencedInstances();
        for (Object e : set) {
            SWRLIndividual sWRLIndividual;
            if (!(e instanceof SWRLIndividual) || e instanceof SWRLBuiltin || (sWRLIndividual = (SWRLIndividual)e).isDeleted()) continue;
            Collection collection = this.getKnowledgeBase().getReferences((Object)sWRLIndividual, -1);
            boolean bl = false;
            for (Reference reference : collection) {
                Frame frame;
                if (slot.equals(reference.getSlot()) || set.contains(frame = reference.getFrame()) || this.equals(frame)) continue;
                bl = true;
            }
            if (bl) continue;
            sWRLIndividual.delete();
        }
    }

    public void deleteImp() {
        this.deleteHeadAndBody();
        this.delete();
    }

    public SWRLAtomList getHead() {
        return (SWRLAtomList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"));
    }

    public Icon getIcon() {
        return this.isEditable() ? SWRLIcons.getImpIcon() : OWLIcons.getReadOnlyIcon(SWRLIcons.getImpIcon(), "RoundedBoxFrame");
    }

    public Set getReferencedInstances() {
        HashSet hashSet = new HashSet();
        this.getReferencedInstances(hashSet);
        return hashSet;
    }

    public void getReferencedInstances(Set set) {
        SWRLAtomList sWRLAtomList;
        SWRLAtomList sWRLAtomList2 = this.getHead();
        if (sWRLAtomList2 != null) {
            set.add(sWRLAtomList2);
            sWRLAtomList2.getReferencedInstances(set);
        }
        if ((sWRLAtomList = this.getBody()) != null) {
            set.add(sWRLAtomList);
            sWRLAtomList.getReferencedInstances(set);
        }
    }

    public SWRLAtomList getBody() {
        return (SWRLAtomList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"));
    }

    public void setBody(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"), sWRLAtomList);
    }

    public String getBrowserText() {
        SWRLAtomList sWRLAtomList = this.getBody();
        SWRLAtomList sWRLAtomList2 = this.getHead();
        if (sWRLAtomList == null) {
            if (sWRLAtomList2 == null) {
                return "<empty rule>";
            }
            return sWRLAtomList2.getBrowserText();
        }
        String string = sWRLAtomList.getBrowserText() + "  " + '\u2192' + "  ";
        if (sWRLAtomList2 == null) {
            return string + "<null>";
        }
        string = string + sWRLAtomList2.getBrowserText();
        return string;
    }

    public void setHead(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"), sWRLAtomList);
    }

    public void setExpression(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.getOWLModel());
        sWRLParser.parse(string);
        this.deleteHeadAndBody();
        sWRLParser.setParseOnly(false);
        sWRLParser.parse(string, this);
    }
}

