/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlb;

import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethods;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInNotImplementedException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import java.util.List;

public class SWRLBuiltInMethodsImpl
implements SWRLBuiltInMethods {
    private static String SWRLB_NAMESPACE = "swrlb";
    private static String SWRLB_GREATER_THAN = SWRLB_NAMESPACE + ":" + "greaterThan";
    private static String SWRLB_LESS_THAN = SWRLB_NAMESPACE + ":" + "lessThan";
    private static String SWRLB_EQUAL = SWRLB_NAMESPACE + ":" + "equal";
    private static String SWRLB_NOT_EQUAL = SWRLB_NAMESPACE + ":" + "notEqual";
    private static String SWRLB_LESS_THAN_OR_EQUAL = SWRLB_NAMESPACE + ":" + "lessThanOrEqual";
    private static String SWRLB_ADD = SWRLB_NAMESPACE + ":" + "add";
    private static String SWRLB_SUBTRACT = SWRLB_NAMESPACE + ":" + "subtract";
    private static String SWRLB_MULTIPLY = SWRLB_NAMESPACE + ":" + "multiply";
    private static String SWRLB_DIVIDE = SWRLB_NAMESPACE + ":" + "divide";
    private static String SWRLB_INTEGER_DIVIDE = SWRLB_NAMESPACE + ":" + "integerDivide";
    private static String SWRLB_MOD = SWRLB_NAMESPACE + ":" + "mod";
    private static String SWRLB_POW = SWRLB_NAMESPACE + ":" + "pow";
    private static String SWRLB_UNARY_PLUS = SWRLB_NAMESPACE + ":" + "unaryPlus";
    private static String SWRLB_UNARY_MINUS = SWRLB_NAMESPACE + ":" + "unaryMinus";
    private static String SWRLB_ABS = SWRLB_NAMESPACE + ":" + "abs";
    private static String SWRLB_CEILING = SWRLB_NAMESPACE + ":" + "ceiling";
    private static String SWRLB_FLOOR = SWRLB_NAMESPACE + ":" + "floor";
    private static String SWRLB_ROUND = SWRLB_NAMESPACE + ":" + "round";
    private static String SWRLB_ROUND_HALF_TO_EVEN = SWRLB_NAMESPACE + ":" + "roundHalfToEven";
    private static String SWRLB_SIN = SWRLB_NAMESPACE + ":" + "sin";
    private static String SWRLB_COS = SWRLB_NAMESPACE + ":" + "cos";
    private static String SWRLB_TAN = SWRLB_NAMESPACE + ":" + "tan";
    private static String SWRLB_BOOLEAN_NOT = SWRLB_NAMESPACE + ":" + "booleanNot";
    private static String SWRLB_STRING_EQUAL_IGNORECASE = SWRLB_NAMESPACE + ":" + "stringEqualIgnoreCase";
    private static String SWRLB_STRING_CONCAT = SWRLB_NAMESPACE + ":" + "stringConcat";
    private static String SWRLB_SUBSTRING = SWRLB_NAMESPACE + ":" + "substring";
    private static String SWRLB_STRING_LENGTH = SWRLB_NAMESPACE + ":" + "stringLength";
    private static String SWRLB_NORMALIZE_SPACE = SWRLB_NAMESPACE + ":" + "normalizeSpace";
    private static String SWRLB_UPPER_CASE = SWRLB_NAMESPACE + ":" + "upperCase";
    private static String SWRLB_LOWER_CASE = SWRLB_NAMESPACE + ":" + "lowerCase";
    private static String SWRLB_TRANSLATE = SWRLB_NAMESPACE + ":" + "translate";
    private static String SWRLB_CONTAINS = SWRLB_NAMESPACE + ":" + "contains";
    private static String SWRLB_CONTAINS_IGNORE_CASE = SWRLB_NAMESPACE + ":" + "containsIgnoreCase";
    private static String SWRLB_STARTS_WITH = SWRLB_NAMESPACE + ":" + "startsWith";
    private static String SWRLB_ENDS_WITH = SWRLB_NAMESPACE + ":" + "endsWith";
    private static String SWRLB_SUBSTRING_BEFORE = SWRLB_NAMESPACE + ":" + "substringBefore";
    private static String SWRLB_SUBSTRING_AFTER = SWRLB_NAMESPACE + ":" + "substringAfter";
    private static String SWRLB_MATCHES = SWRLB_NAMESPACE + ":" + "matches";
    private static String SWRLB_REPLACE = SWRLB_NAMESPACE + ":" + "replace";
    private static String SWRLB_TOKENIZE = SWRLB_NAMESPACE + ":" + "tokenize";

    public boolean greaterThan(List list) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(SWRLB_GREATER_THAN, list) > 0;
    }

    public boolean lessThan(List list) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(SWRLB_LESS_THAN, list) < 0;
    }

    public boolean equal(List list) throws BuiltInException {
        return this.equal(SWRLB_EQUAL, list);
    }

    public boolean notEqual(List list) throws BuiltInException {
        return !this.equal(SWRLB_NOT_EQUAL, list);
    }

    public boolean lessThanOrEqual(List list) throws BuiltInException {
        return this.equal(SWRLB_LESS_THAN_OR_EQUAL, list) || this.lessThan(SWRLB_LESS_THAN_OR_EQUAL, list);
    }

    public boolean add(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_ADD, 2, list.size());
        return this.mathOperation(SWRLB_ADD, list);
    }

    public boolean subtract(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_SUBTRACT, 3, list.size());
        return this.mathOperation(SWRLB_SUBTRACT, list);
    }

    public boolean multiply(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_MULTIPLY, 2, list.size());
        return this.mathOperation(SWRLB_MULTIPLY, list);
    }

    public boolean divide(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_DIVIDE, 3, list.size());
        return this.mathOperation(SWRLB_DIVIDE, list);
    }

    public boolean integerDivide(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_INTEGER_DIVIDE, 3, list.size());
        return this.mathOperation(SWRLB_INTEGER_DIVIDE, list);
    }

    public boolean mod(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_MOD, 3, list.size());
        return this.mathOperation(SWRLB_MOD, list);
    }

    public boolean pow(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_POW, 3, list.size());
        return this.mathOperation(SWRLB_POW, list);
    }

    public boolean unaryPlus(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UNARY_PLUS, 2, list.size());
        return this.mathOperation(SWRLB_UNARY_PLUS, list);
    }

    public boolean unaryMinus(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UNARY_MINUS, 2, list.size());
        return this.mathOperation(SWRLB_UNARY_MINUS, list);
    }

    public boolean abs(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ABS, 2, list.size());
        return this.mathOperation(SWRLB_ABS, list);
    }

    public boolean ceiling(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CEILING, 2, list.size());
        return this.mathOperation(SWRLB_CEILING, list);
    }

    public boolean floor(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_FLOOR, 2, list.size());
        return this.mathOperation(SWRLB_FLOOR, list);
    }

    public boolean round(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ROUND, 2, list.size());
        return this.mathOperation(SWRLB_ROUND, list);
    }

    public boolean sin(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_SIN, 2, list.size());
        return this.mathOperation(SWRLB_SIN, list);
    }

    public boolean cos(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_COS, 2, list.size());
        return this.mathOperation(SWRLB_COS, list);
    }

    public boolean tan(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_TAN, 2, list.size());
        return this.mathOperation(SWRLB_TAN, list);
    }

    public boolean booleanNot(List list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_BOOLEAN_NOT, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_BOOLEAN_NOT, list)) {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(SWRLB_BOOLEAN_NOT, list.subList(1, list.size()))) {
                throw new InvalidBuiltInArgumentException(SWRLB_BOOLEAN_NOT, 1, "Expecting a Boolean");
            }
            boolean bl2 = !SWRLBuiltInUtil.getArgumentAsABoolean(SWRLB_BOOLEAN_NOT, 1, list);
            list.set(0, new LiteralInfo(bl2));
            bl = true;
        } else {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(SWRLB_BOOLEAN_NOT, list)) {
                throw new InvalidBuiltInArgumentException(SWRLB_BOOLEAN_NOT, "Expecting all Boolean arguments");
            }
            bl = !this.equal(SWRLB_BOOLEAN_NOT, list);
        }
        return bl;
    }

    public boolean stringEqualIgnoreCase(List list) throws BuiltInException {
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_EQUAL_IGNORECASE, list)) {
            throw new InvalidBuiltInArgumentException(SWRLB_STRING_EQUAL_IGNORECASE, 0, "Comparison built-ins do not support assignment. Unbound variable used");
        }
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STRING_EQUAL_IGNORECASE, 2, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_EQUAL_IGNORECASE, 0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_EQUAL_IGNORECASE, 1, list);
        return string.equalsIgnoreCase(string2);
    }

    public boolean stringConcat(List list) throws BuiltInException {
        boolean bl;
        String string = "";
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_STRING_CONCAT, 2, list.size());
        for (int i = 1; i < list.size(); ++i) {
            string = string.concat(SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_CONCAT, i, list));
        }
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_CONCAT, list)) {
            list.set(0, new LiteralInfo(string));
            bl = true;
        } else {
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STRING_CONCAT, 0, list);
            bl = string2.equals(string);
        }
        return bl;
    }

    public boolean substring(List list) throws BuiltInException {
        boolean bl;
        String string;
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(SWRLB_SUBSTRING, 3, list.size());
        SWRLBuiltInUtil.checkNumberOfArgumentsAtMost(SWRLB_SUBSTRING, 4, list.size());
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 1, list);
        int n = SWRLBuiltInUtil.getArgumentAsAnInteger(SWRLB_SUBSTRING, 2, list);
        if (list.size() == 4) {
            int n2 = SWRLBuiltInUtil.getArgumentAsAnInteger(SWRLB_SUBSTRING, 3, list);
            string = string2.substring(n, n2);
        } else {
            string = string2.substring(n);
        }
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_SUBSTRING, list)) {
            list.set(0, new LiteralInfo(string));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 0, list);
            bl = string3.equals(string);
        }
        return bl;
    }

    public boolean stringLength(List list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STRING_LENGTH, 2, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 1, list);
        int n = string.length();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_STRING_LENGTH, list)) {
            list.set(0, new LiteralInfo(n));
            bl = true;
        } else {
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_SUBSTRING, 0, list);
            bl = string2.length() == n;
        }
        return bl;
    }

    public boolean upperCase(List list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_UPPER_CASE, 2, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_UPPER_CASE, 1, list);
        String string2 = string.toUpperCase();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_UPPER_CASE, list)) {
            list.set(0, new LiteralInfo(string2));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_UPPER_CASE, 0, list);
            bl = string3.equals(string2);
        }
        return bl;
    }

    public boolean lowerCase(List list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_LOWER_CASE, 2, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_LOWER_CASE, 1, list);
        String string2 = string.toLowerCase();
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_LOWER_CASE, list)) {
            list.set(0, new LiteralInfo(string2));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_LOWER_CASE, 0, list);
            bl = string3.equals(string2);
        }
        return bl;
    }

    public boolean contains(List list) throws BuiltInException {
        String string;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CONTAINS, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS, list)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS, 0, list);
        return string2.lastIndexOf(string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS, 1, list)) != -1;
    }

    public boolean containsIgnoreCase(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_CONTAINS_IGNORE_CASE, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS_IGNORE_CASE, list)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS_IGNORE_CASE, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS_IGNORE_CASE, 0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_CONTAINS_IGNORE_CASE, 1, list);
        return string.toLowerCase().lastIndexOf(string2.toLowerCase()) != -1;
    }

    public boolean startsWith(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_STARTS_WITH, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_CONTAINS_IGNORE_CASE, list)) {
            throw new InvalidBuiltInArgumentException(SWRLB_CONTAINS_IGNORE_CASE, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STARTS_WITH, 0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_STARTS_WITH, 1, list);
        return string.startsWith(string2);
    }

    public boolean endsWith(List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(SWRLB_ENDS_WITH, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(SWRLB_ENDS_WITH, list)) {
            throw new InvalidBuiltInArgumentException(SWRLB_ENDS_WITH, 0, "Built-in does not support assignment. Unbound variable used");
        }
        String string = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_ENDS_WITH, 0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(SWRLB_ENDS_WITH, 1, list);
        return string.endsWith(string2);
    }

    private boolean equal(String string, List list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(string, 2, list.size());
        if (SWRLBuiltInUtil.isExpectingAssignment(string, list)) {
            throw new InvalidBuiltInArgumentException(string, 0, "Comparison built-ins do not support assignment. Unbound variable used");
        }
        if (SWRLBuiltInUtil.isArgumentABoolean(0, list)) {
            boolean bl;
            boolean bl2 = SWRLBuiltInUtil.getArgumentAsABoolean(string, 0, list);
            return bl2 == (bl = SWRLBuiltInUtil.getArgumentAsABoolean(string, 1, list));
        }
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(string, list) == 0;
    }

    private static int compareTwoArgumentsOfOrderedType(String string, List list) throws BuiltInException {
        int n = 0;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(string, 2, list.size());
        SWRLBuiltInUtil.checkThatAllArgumentsAreOfAnOrderedType(string, list);
        if (SWRLBuiltInUtil.isArgumentAString(0, list)) {
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(string, 0, list);
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(string, 1, list);
            return string2.compareTo(string3);
        }
        if (SWRLBuiltInUtil.isArgumentAnInteger(0, list)) {
            int n2;
            int n3 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 0, list);
            n = n3 < (n2 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list)) ? -1 : (n3 > n2 ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentALong(0, list)) {
            long l;
            long l2 = SWRLBuiltInUtil.getArgumentAsALong(string, 0, list);
            n = l2 < (l = SWRLBuiltInUtil.getArgumentAsALong(string, 1, list)) ? -1 : (l2 > l ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentAFloat(0, list)) {
            float f;
            float f2 = SWRLBuiltInUtil.getArgumentAsAFloat(string, 0, list);
            n = f2 < (f = SWRLBuiltInUtil.getArgumentAsAFloat(string, 1, list)) ? -1 : (f2 > f ? 1 : 0);
        } else if (SWRLBuiltInUtil.isArgumentADouble(0, list)) {
            double d;
            double d2 = SWRLBuiltInUtil.getArgumentAsADouble(string, 0, list);
            n = d2 < (d = SWRLBuiltInUtil.getArgumentAsADouble(string, 1, list)) ? -1 : (d2 > d ? 1 : 0);
        } else {
            throw new InvalidBuiltInArgumentException(string, 1, "Unknown argument type");
        }
        return n;
    }

    private boolean lessThan(String string, List list) throws BuiltInException {
        return SWRLBuiltInMethodsImpl.compareTwoArgumentsOfOrderedType(string, list) < 0;
    }

    private boolean mathOperation(String string, List list) throws BuiltInException {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        if (SWRLBuiltInUtil.isExpectingAssignment(string, list)) {
            bl2 = true;
        }
        if (bl2 ? !SWRLBuiltInUtil.areAllArgumentsIntegers(string, list.subList(1, list.size())) : !SWRLBuiltInUtil.areAllArgumentsIntegers(string, list)) {
            throw new BuiltInNotImplementedException(string, "Only built-ins with all integer arguments are supported at the moment");
        }
        if (!bl2) {
            n = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 0, list);
        }
        if (string.equalsIgnoreCase(SWRLB_ADD)) {
            n2 = 0;
            for (int i = 1; i < list.size(); ++i) {
                n2 += SWRLBuiltInUtil.getArgumentAsAnInteger(string, i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_MULTIPLY)) {
            n2 = 1;
            for (int i = 1; i < list.size(); ++i) {
                n2 *= SWRLBuiltInUtil.getArgumentAsAnInteger(string, i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_SUBTRACT)) {
            int n3 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            int n4 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 2, list);
        } else if (string.equalsIgnoreCase(SWRLB_DIVIDE)) {
            int n5 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            int n6 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 2, list);
            n2 = n5 / n6;
        } else if (string.equalsIgnoreCase(SWRLB_INTEGER_DIVIDE)) {
            int n7 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            int n8 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 2, list);
            if (n8 == 0) {
                throw new InvalidBuiltInArgumentException(string, 2, "Zero passed as divisor");
            }
            n2 = n8 >= 0 ? n7 + n8 + 1 / n8 : n7 / n8;
        } else if (string.equalsIgnoreCase(SWRLB_MOD)) {
            int n9 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            int n10 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 2, list);
            n2 = n9 % n10;
        } else if (string.equalsIgnoreCase(SWRLB_POW)) {
            int n11 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            int n12 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 2, list);
            n2 = (int)Math.pow(n11, n12);
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_PLUS)) {
            int n13;
            n2 = n13 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_MINUS)) {
            int n14 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            n2 = -n14;
        } else if (string.equalsIgnoreCase(SWRLB_ABS)) {
            int n15 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            n2 = Math.abs(n15);
        } else if (string.equalsIgnoreCase(SWRLB_CEILING)) {
            int n16 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            n2 = (int)Math.ceil(n16);
        } else if (string.equalsIgnoreCase(SWRLB_FLOOR)) {
            int n17 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            n2 = (int)Math.floor(n17);
        } else if (string.equalsIgnoreCase(SWRLB_ROUND)) {
            int n18 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
            n2 = (int)Math.rint(n18);
        } else {
            if (string.equalsIgnoreCase(SWRLB_ROUND_HALF_TO_EVEN)) {
                int n19 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
                throw new BuiltInNotImplementedException(SWRLB_ROUND_HALF_TO_EVEN);
            }
            if (string.equalsIgnoreCase(SWRLB_SIN)) {
                int n20 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
                n2 = (int)Math.sin(n20);
            } else if (string.equalsIgnoreCase(SWRLB_COS)) {
                int n21 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
                n2 = (int)Math.cos(n21);
            } else if (string.equalsIgnoreCase(SWRLB_TAN)) {
                int n22 = SWRLBuiltInUtil.getArgumentAsAnInteger(string, 1, list);
                n2 = (int)Math.tan(n22);
            } else {
                throw new InvalidBuiltInNameException(string);
            }
        }
        if (bl2) {
            list.set(0, new LiteralInfo(n2));
            bl = true;
        } else {
            bl = n == n2;
        }
        return bl;
    }
}

