/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.AllDifferentRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DataRangeAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatavaluedPropertyAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DifferentFromRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DifferentIndividualsAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualPropertyAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.PropertyInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.RestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.RuleInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.SameAsRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.SameIndividualAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethods;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInMethodRuntimeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InconsistentKnowledgeBaseException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidSWRLAtomException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class SWRLRuleEngineBridge {
    protected OWLModel owlModel;
    private List importedSWRLRules;
    private List referencedClassNames;
    private List referencedPropertyNames;
    private List referencedIndividualNames;
    private HashMap importedClasses;
    private HashMap importedIndividuals;
    private List importedProperties;
    private List importedPropertyNames;
    private List importedRestrictions;
    private List exportedClassNames;
    private List exportedIndividualNames;
    private List assertedIndividuals;
    private List assertedProperties;
    private HashMap builtInMethodsClassInstances;

    protected abstract void defineRule(RuleInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineClass(ClassInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineProperty(PropertyInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineIndividual(IndividualInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineRestriction(RestrictionInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void initializeRuleEngine() throws SWRLRuleEngineBridgeException;

    public abstract void runRuleEngine() throws SWRLRuleEngineBridgeException;

    protected SWRLRuleEngineBridge(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        this.owlModel = oWLModel;
        this.importedSWRLRules = new ArrayList();
        this.referencedClassNames = new ArrayList();
        this.referencedIndividualNames = new ArrayList();
        this.referencedPropertyNames = new ArrayList();
        this.importedClasses = new HashMap();
        this.importedIndividuals = new HashMap();
        this.importedProperties = new ArrayList();
        this.importedPropertyNames = new ArrayList();
        this.importedRestrictions = new ArrayList();
        this.exportedClassNames = new ArrayList();
        this.exportedIndividualNames = new ArrayList();
        this.assertedIndividuals = new ArrayList();
        this.assertedProperties = new ArrayList();
        this.builtInMethodsClassInstances = new HashMap();
    }

    public void importSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.resetRuleEngine();
        if (!this.owlModel.getInconsistentClasses().isEmpty()) {
            throw new InconsistentKnowledgeBaseException("Cannot import rules from an inconsistent knowledge base");
        }
        this.importSWRLRules();
        this.importOWLClasses(this.referencedClassNames);
        this.importOWLProperties(this.referencedPropertyNames);
        this.importOWLIndividuals(this.referencedIndividualNames);
        this.importAllOWLIndividualsOfClasses(this.referencedClassNames);
        this.importOWLRestrictions();
    }

    public void exportSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.exportOWLClasses();
        this.exportOWLIndividuals();
        this.exportOWLProperties();
        this.exportOWLRestrictions();
        this.exportSWRLRules();
    }

    public void writeAssertedIndividualsAndProperties2OWL() throws SWRLRuleEngineBridgeException {
        this.writeAssertedIndividuals2OWL();
        this.writeAssertedProperties2OWL();
    }

    public void resetBridge() throws SWRLRuleEngineBridgeException {
        this.importedSWRLRules.clear();
        this.referencedClassNames.clear();
        this.referencedPropertyNames.clear();
        this.referencedIndividualNames.clear();
        this.importedClasses.clear();
        this.importedProperties.clear();
        this.importedPropertyNames.clear();
        this.importedIndividuals.clear();
        this.importedRestrictions.clear();
        this.clearExportedAndAssertedKnowledge();
        this.resetRuleEngine();
    }

    public void resetRuleEngine() throws SWRLRuleEngineBridgeException {
        this.initializeRuleEngine();
        this.clearExportedAndAssertedKnowledge();
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public int getNumberOfImportedSWRLRules() {
        return this.importedSWRLRules.size();
    }

    public int getNumberOfImportedClasses() {
        return this.importedClasses.size();
    }

    public int getNumberOfImportedIndividuals() {
        return this.importedIndividuals.size();
    }

    public int getNumberOfImportedProperties() {
        return this.importedProperties.size();
    }

    public int getNumberOfImportedRestrictions() {
        return this.importedRestrictions.size();
    }

    public int getNumberOfAssertedIndividuals() {
        return this.assertedIndividuals.size();
    }

    public int getNumberOfAssertedProperties() {
        return this.assertedProperties.size();
    }

    protected List getImportedSWRLRules() {
        return this.importedSWRLRules;
    }

    protected List getImportedClasses() {
        return new ArrayList(this.importedClasses.values());
    }

    protected List getImportedIndividuals() {
        return new ArrayList(this.importedIndividuals.values());
    }

    protected List getImportedProperties() {
        return this.importedProperties;
    }

    protected List getImportedRestrictions() {
        return this.importedRestrictions;
    }

    protected List getAssertedIndividuals() {
        return this.assertedIndividuals;
    }

    protected List getAssertedProperties() {
        return this.assertedProperties;
    }

    public void assertProperty(String string, String string2, String string3) throws SWRLRuleEngineBridgeException {
        IndividualInfo individualInfo = new IndividualInfo(string2);
        Info info = this.isObjectProperty(string) ? new IndividualInfo(string3) : new LiteralInfo(string3);
        PropertyInfo propertyInfo = new PropertyInfo(string, individualInfo, (Argument)((Object)info));
        if (!this.assertedProperties.contains(propertyInfo)) {
            this.assertedProperties.add(propertyInfo);
        }
    }

    public void assertIndividual(String string, String string2) throws SWRLRuleEngineBridgeException {
        IndividualInfo individualInfo = new IndividualInfo(string, string2);
        if (!this.assertedIndividuals.contains(individualInfo)) {
            this.assertedIndividuals.add(individualInfo);
        }
    }

    public boolean invokeSWRLBuiltIn(String string, List list) throws BuiltInException {
        String string2;
        SWRLBuiltInMethods sWRLBuiltInMethods = null;
        Object var4_4 = null;
        String string3 = "";
        String string4 = "";
        Boolean bl = false;
        if (!this.isBuiltIn(string)) {
            throw new InvalidBuiltInNameException(string);
        }
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1, string.length());
            string2 = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins." + string3 + ".SWRLBuiltInMethodsImpl";
        } else {
            string3 = "";
            string4 = string;
            string2 = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethodsImpl";
        }
        if (this.builtInMethodsClassInstances.containsKey(string3)) {
            sWRLBuiltInMethods = (SWRLBuiltInMethods)this.builtInMethodsClassInstances.get(string3);
        } else {
            sWRLBuiltInMethods = this.loadSWRLBuiltInMethodsImpl(string3, string2);
            this.builtInMethodsClassInstances.put(string3, sWRLBuiltInMethods);
        }
        Method method = this.resolveBuiltInMethod(string3, string4, sWRLBuiltInMethods);
        this.checkBuiltInMethod(string3, string4, method);
        try {
            bl = (Boolean)method.invoke((Object)sWRLBuiltInMethods, list);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BuiltInException) {
                throw (BuiltInException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw new BuiltInMethodRuntimeException(string3, string4, throwable.getMessage(), throwable);
            }
        }
        catch (Exception exception) {
            throw new BuiltInException("Internal bridge exception when invoking built-in method '" + string4 + "' in namespace '" + string3 + "'. Exception: " + exception.toString(), exception);
        }
        return bl;
    }

    private Method resolveBuiltInMethod(String string, String string2, SWRLBuiltInMethods sWRLBuiltInMethods) throws UnresolvedBuiltInMethodException {
        Method method;
        try {
            method = sWRLBuiltInMethods.getClass().getMethod(string2, List.class);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInMethodException(string, string2, exception.getMessage());
        }
        return method;
    }

    private SWRLBuiltInMethods loadSWRLBuiltInMethodsImpl(String string, String string2) throws UnresolvedBuiltInClassException, IncompatibleBuiltInClassException {
        SWRLBuiltInMethods sWRLBuiltInMethods;
        Class<?> clazz;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInClassException(string, exception.getMessage());
        }
        this.checkBuiltInClass(string, clazz);
        try {
            sWRLBuiltInMethods = (SWRLBuiltInMethods)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInClassException(string, exception.getMessage());
        }
        return sWRLBuiltInMethods;
    }

    private void importSWRLRules() throws SWRLRuleEngineBridgeException {
        SWRLFactory sWRLFactory = new SWRLFactory(this.owlModel);
        Collection collection = sWRLFactory.getImps();
        if (collection == null) {
            return;
        }
        for (SWRLImp sWRLImp : collection) {
            this.importSWRLRule(sWRLImp);
        }
    }

    private void importSWRLRule(SWRLImp sWRLImp) throws SWRLRuleEngineBridgeException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        RuleInfo ruleInfo = new RuleInfo(sWRLImp.getName());
        for (SWRLAtom sWRLAtom : sWRLImp.getBody().getValues()) {
            ruleInfo.addBodyAtom(this.processSWRLAtom(sWRLAtom, false));
        }
        for (SWRLAtom sWRLAtom : sWRLImp.getHead().getValues()) {
            ruleInfo.addHeadAtom(this.processSWRLAtom(sWRLAtom, true));
        }
        this.preProcessAtoms(ruleInfo);
        this.importedSWRLRules.add(ruleInfo);
    }

    private AtomInfo processSWRLAtom(SWRLAtom sWRLAtom, boolean bl) throws SWRLRuleEngineBridgeException {
        AtomInfo atomInfo;
        if (sWRLAtom instanceof SWRLClassAtom) {
            atomInfo = new ClassAtomInfo((SWRLClassAtom)sWRLAtom);
            if (!this.referencedClassNames.contains(atomInfo.getName())) {
                this.referencedClassNames.add(atomInfo.getName());
            }
        } else if (sWRLAtom instanceof SWRLDatavaluedPropertyAtom) {
            atomInfo = new DatavaluedPropertyAtomInfo(this.owlModel, (SWRLDatavaluedPropertyAtom)sWRLAtom);
            if (!this.referencedPropertyNames.contains(atomInfo.getName())) {
                this.referencedPropertyNames.add(atomInfo.getName());
            }
        } else if (sWRLAtom instanceof SWRLIndividualPropertyAtom) {
            atomInfo = new IndividualPropertyAtomInfo((SWRLIndividualPropertyAtom)sWRLAtom);
            if (!this.referencedPropertyNames.contains(atomInfo.getName())) {
                this.referencedPropertyNames.add(atomInfo.getName());
            }
        } else if (sWRLAtom instanceof SWRLSameIndividualAtom) {
            atomInfo = new SameIndividualAtomInfo((SWRLSameIndividualAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLDifferentIndividualsAtom) {
            atomInfo = new DifferentIndividualsAtomInfo((SWRLDifferentIndividualsAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLBuiltinAtom) {
            atomInfo = new BuiltInAtomInfo(this.owlModel, (SWRLBuiltinAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLDataRangeAtom) {
            atomInfo = new DataRangeAtomInfo((SWRLDataRangeAtom)sWRLAtom);
        } else {
            throw new InvalidSWRLAtomException(sWRLAtom.getBrowserText());
        }
        if (atomInfo.hasReferencedIndividuals()) {
            this.referencedIndividualNames.addAll(atomInfo.getReferencedIndividualNames());
        }
        return atomInfo;
    }

    private void importOWLClass(String string) throws SWRLRuleEngineBridgeException {
        if (!this.importedClasses.containsKey(string)) {
            ClassInfo classInfo = new ClassInfo(this.owlModel, string);
            this.importedClasses.put(string, classInfo);
            this.importOWLClasses(classInfo.getDirectSuperClassNames());
            this.importOWLClasses(classInfo.getDirectSubClassNames());
        }
    }

    private void importOWLClasses(Collection collection) throws SWRLRuleEngineBridgeException {
        for (String string : collection) {
            this.importOWLClass(string);
        }
    }

    private void importAllOWLIndividualsOfClasses(Collection collection) throws SWRLRuleEngineBridgeException {
        for (String string : collection) {
            this.importAllOWLIndividualsOfClass(string);
        }
    }

    private void importAllOWLIndividualsOfClass(String string) throws SWRLRuleEngineBridgeException {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass(string);
        if (rDFSNamedClass == null) {
            throw new InvalidClassNameException(string);
        }
        for (Object e : rDFSNamedClass.getInstances(true)) {
            if (!(e instanceof OWLIndividual)) continue;
            OWLIndividual oWLIndividual = (OWLIndividual)e;
            String string2 = oWLIndividual.getName();
            IndividualInfo individualInfo = new IndividualInfo(this.owlModel, string2);
            this.importedIndividuals.put(string2, individualInfo);
        }
    }

    private void importOWLProperties(Collection collection) throws SWRLRuleEngineBridgeException {
        for (String string : collection) {
            this.importOWLProperty(string);
        }
    }

    private void importOWLProperty(String string) throws SWRLRuleEngineBridgeException {
        if (!this.importedPropertyNames.contains(string)) {
            List list = PropertyInfo.buildPropertyInfoList(this.owlModel, string);
            this.importedProperties.addAll(list);
            this.importedPropertyNames.add(string);
            if (!list.isEmpty()) {
                PropertyInfo propertyInfo = (PropertyInfo)list.get(0);
                this.importOWLClasses(propertyInfo.getDomainClassNames());
                this.importOWLClasses(propertyInfo.getRangeClassNames());
            }
        }
    }

    private void importOWLIndividuals(Collection collection) throws SWRLRuleEngineBridgeException {
        for (String string : collection) {
            this.importOWLIndividual(string);
        }
    }

    private void importOWLIndividual(String string) throws SWRLRuleEngineBridgeException {
        if (!this.importedIndividuals.containsKey(string)) {
            return;
        }
        IndividualInfo individualInfo = new IndividualInfo(this.owlModel, string);
        this.importedIndividuals.put(string, individualInfo);
        this.importOWLClasses(individualInfo.getClassNames());
    }

    private void importOWLRestrictions() throws SWRLRuleEngineBridgeException {
        this.importOWLSameAsRestrictions();
        this.importOWLDifferentFromRestrictions();
        this.importOWLAllDifferents();
    }

    private void importOWLSameAsRestrictions() throws SWRLRuleEngineBridgeException {
        RDFProperty rDFProperty = this.owlModel.getOWLSameAsProperty();
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClass("owl:Thing");
        for (Object e : oWLNamedClass.getInstances(true)) {
            OWLIndividual oWLIndividual;
            if (!(e instanceof OWLIndividual) || !(oWLIndividual = (OWLIndividual)e).hasPropertyValue(rDFProperty)) continue;
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e2 : collection) {
                if (!(e2 instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual2 = (OWLIndividual)e2;
                this.importedRestrictions.add(new SameAsRestrictionInfo(oWLIndividual.getName(), oWLIndividual2.getName()));
            }
        }
    }

    private void importOWLDifferentFromRestrictions() throws SWRLRuleEngineBridgeException {
        RDFProperty rDFProperty = this.owlModel.getOWLDifferentFromProperty();
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClass("owl:Thing");
        for (Object e : oWLNamedClass.getInstances(true)) {
            OWLIndividual oWLIndividual;
            if (!(e instanceof OWLIndividual) || !(oWLIndividual = (OWLIndividual)e).hasPropertyValue(rDFProperty)) continue;
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e2 : collection) {
                if (!(e2 instanceof OWLIndividual)) continue;
                OWLIndividual oWLIndividual2 = (OWLIndividual)e2;
                this.importedRestrictions.add(new DifferentFromRestrictionInfo(oWLIndividual.getName(), oWLIndividual2.getName()));
            }
        }
    }

    private void importOWLAllDifferents() throws SWRLRuleEngineBridgeException {
        Collection collection = this.owlModel.getOWLAllDifferents();
        if (!collection.isEmpty()) {
            for (OWLAllDifferent oWLAllDifferent : collection) {
                AllDifferentRestrictionInfo allDifferentRestrictionInfo = new AllDifferentRestrictionInfo();
                for (RDFIndividual rDFIndividual : oWLAllDifferent.getDistinctMembers()) {
                    allDifferentRestrictionInfo.addIndividualName(rDFIndividual.getName());
                }
                this.importedRestrictions.add(allDifferentRestrictionInfo);
            }
        }
    }

    private void exportSWRLRules() throws SWRLRuleEngineBridgeException {
        for (RuleInfo ruleInfo : this.importedSWRLRules) {
            this.defineRule(ruleInfo);
        }
    }

    private void exportOWLClasses() throws SWRLRuleEngineBridgeException {
        for (ClassInfo classInfo : this.importedClasses.values()) {
            this.exportOWLClass(classInfo);
        }
    }

    private void exportOWLClass(ClassInfo classInfo) throws SWRLRuleEngineBridgeException {
        String string = classInfo.getName();
        List list = classInfo.getDirectSuperClassNames();
        if (!this.exportedClassNames.contains(string)) {
            if (!list.isEmpty()) {
                for (String string2 : list) {
                    ClassInfo classInfo2 = (ClassInfo)this.importedClasses.get(string2);
                    this.exportOWLClass(classInfo2);
                }
            }
            this.defineClass(classInfo);
            this.exportedClassNames.add(string);
        }
    }

    private void exportOWLProperties() throws SWRLRuleEngineBridgeException {
        for (PropertyInfo propertyInfo : this.importedProperties) {
            String string = propertyInfo.getName();
            this.defineProperty(propertyInfo);
        }
    }

    private void exportOWLIndividuals() throws SWRLRuleEngineBridgeException {
        for (IndividualInfo individualInfo : this.importedIndividuals.values()) {
            String string = individualInfo.getName();
            if (this.exportedIndividualNames.contains(string)) continue;
            this.defineIndividual(individualInfo);
            this.exportedIndividualNames.add(string);
        }
    }

    private void exportOWLRestrictions() throws SWRLRuleEngineBridgeException {
        for (RestrictionInfo restrictionInfo : this.importedRestrictions) {
            this.defineRestriction(restrictionInfo);
        }
    }

    private void writeAssertedProperties2OWL() throws SWRLRuleEngineBridgeException {
        for (PropertyInfo propertyInfo : this.assertedProperties) {
            propertyInfo.write2OWL(this.owlModel);
        }
    }

    private void writeAssertedIndividuals2OWL() throws SWRLRuleEngineBridgeException {
        for (IndividualInfo individualInfo : this.assertedIndividuals) {
            individualInfo.write2OWL(this.owlModel);
        }
    }

    private void preProcessAtoms(RuleInfo ruleInfo) throws SWRLRuleEngineBridgeException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<AtomInfo> arrayList3 = new ArrayList<AtomInfo>();
        ArrayList<AtomInfo> arrayList4 = new ArrayList<AtomInfo>();
        ArrayList<AtomInfo> arrayList5 = new ArrayList<AtomInfo>();
        ArrayList<AtomInfo> arrayList6 = new ArrayList<AtomInfo>();
        ArrayList arrayList7 = new ArrayList();
        ArrayList<Object> arrayList8 = new ArrayList<Object>();
        for (AtomInfo atomInfo : ruleInfo.getBodyAtoms()) {
            if (atomInfo instanceof BuiltInAtomInfo) {
                arrayList4.add(atomInfo);
                continue;
            }
            arrayList3.add(atomInfo);
            arrayList7.addAll(atomInfo.getReferencedVariableNames());
        }
        for (AtomInfo atomInfo : arrayList4) {
            List list = atomInfo.getReferencedVariableNames();
            if (((BuiltInAtomInfo)atomInfo).isFirstArgumentAVariable()) {
                String string = ((BuiltInAtomInfo)atomInfo).getFirstArgumentVariableName();
                if (!arrayList7.contains(string)) {
                    if (arrayList8.contains(string)) {
                        throw new SWRLRuleEngineBridgeException("Attempt to set variable ?" + (String)string + " for second time by built-in '" + atomInfo.getName() + "'.");
                    }
                    arrayList8.add(string);
                    arrayList6.add(atomInfo);
                    list.remove(0);
                } else {
                    arrayList5.add(atomInfo);
                }
            } else {
                arrayList5.add(atomInfo);
            }
            for (String string : list) {
                if (arrayList7.contains(string)) continue;
                throw new SWRLRuleEngineBridgeException("Variable ?" + string + " in by built-in '" + atomInfo.getName() + "' used before definition.");
            }
        }
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList5);
        arrayList2.addAll(arrayList6);
        arrayList2.addAll(ruleInfo.getHeadAtoms());
        ruleInfo.setBodyAtoms(arrayList);
        ruleInfo.setHeadAtoms(arrayList2);
    }

    private void clearExportedAndAssertedKnowledge() {
        this.exportedClassNames.clear();
        this.exportedIndividualNames.clear();
        this.assertedProperties.clear();
        this.assertedIndividuals.clear();
    }

    private boolean isBuiltIn(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        return rDFResource != null && rDFResource.getProtegeType().getName().equals("swrl:Builtin");
    }

    private boolean isObjectProperty(String string) throws SWRLRuleEngineBridgeException {
        OWLProperty oWLProperty = this.owlModel.getOWLProperty(string);
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(string);
        }
        return oWLProperty.isObjectProperty();
    }

    private void checkBuiltInMethod(String string, String string2, Method method) throws IncompatibleBuiltInMethodException {
        if (method.getReturnType() != Boolean.TYPE) {
            throw new IncompatibleBuiltInMethodException(string, string2, "Method does not return a boolean.");
        }
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray.length != 1 || classArray[0] != BuiltInException.class) {
            throw new IncompatibleBuiltInMethodException(string, string2, "Built-in method must throw a single exception of type BuiltInException.");
        }
    }

    private void checkBuiltInClass(String string, Class clazz) throws IncompatibleBuiltInClassException {
        if (!SWRLBuiltInMethods.class.isAssignableFrom(clazz)) {
            throw new IncompatibleBuiltInClassException(string, clazz.getName(), "Class does not implement SWRLBuiltInMethods.");
        }
    }
}

