/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidIndividualNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.List;

public class PropertyInfo
extends Info {
    private Argument subject;
    private Argument predicate;
    private List domainClassNames;
    private List rangeClassNames;

    public PropertyInfo(String string, Argument argument, Argument argument2, List list, List list2) throws SWRLRuleEngineBridgeException {
        super(string);
        this.subject = argument;
        this.predicate = argument2;
        this.domainClassNames = list;
        this.rangeClassNames = list2;
    }

    public PropertyInfo(String string, Argument argument, Argument argument2) throws SWRLRuleEngineBridgeException {
        super(string);
        this.subject = argument;
        this.predicate = argument2;
    }

    public Argument getSubject() {
        return this.subject;
    }

    public Argument getPredicate() {
        return this.predicate;
    }

    public List getDomainClassNames() {
        return this.domainClassNames;
    }

    public List getRangeClassNames() {
        return this.rangeClassNames;
    }

    public void write2OWL(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        Object object;
        OWLProperty oWLProperty = this.getName().equalsIgnoreCase("sameAs") ? (OWLProperty)oWLModel.getOWLSameAsProperty() : (this.getName().equalsIgnoreCase("differentFrom") ? (OWLProperty)oWLModel.getOWLDifferentFromProperty() : oWLModel.getOWLProperty(this.getName()));
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(this.getName());
        }
        OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(this.subject.getName());
        if (oWLIndividual == null) {
            throw new InvalidIndividualNameException(this.subject.getName());
        }
        if (oWLProperty.isObjectProperty()) {
            object = oWLModel.getOWLIndividual(this.predicate.getName());
            if (object == null) {
                throw new InvalidIndividualNameException(this.predicate.getName());
            }
        } else {
            LiteralInfo literalInfo = (LiteralInfo)this.predicate;
            object = literalInfo.isString() ? literalInfo.getString() : oWLModel.asRDFSLiteral(literalInfo.getString());
        }
        if (!oWLIndividual.hasPropertyValue(oWLProperty, object, true)) {
            oWLIndividual.addPropertyValue(oWLProperty, object);
        }
    }

    public String toString() {
        return "Property(name: " + this.getName() + ", subject: " + this.subject + ", predicate: " + this.predicate + ", domainClassNames: " + this.domainClassNames + ", rangeClassNames: " + this.rangeClassNames + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        PropertyInfo propertyInfo = (PropertyInfo)object;
        return (this.getName() == propertyInfo.getName() || this.getName() != null && this.getName().equals(propertyInfo.getName())) && (this.subject == propertyInfo.subject || this.subject != null && this.subject.equals(propertyInfo.subject)) && (this.predicate == propertyInfo.predicate || this.predicate != null && this.predicate.equals(propertyInfo.predicate)) && (this.domainClassNames == propertyInfo.domainClassNames || this.domainClassNames != null && ((Object)this.domainClassNames).equals(propertyInfo.domainClassNames)) && (this.rangeClassNames == propertyInfo.rangeClassNames || this.rangeClassNames != null && ((Object)this.rangeClassNames).equals(propertyInfo.rangeClassNames));
    }

    public int hashCode() {
        int n = 767;
        n += null == this.getName() ? 0 : this.getName().hashCode();
        n += null == this.subject ? 0 : this.subject.hashCode();
        n += null == this.predicate ? 0 : this.predicate.hashCode();
        n += null == this.domainClassNames ? 0 : ((Object)this.domainClassNames).hashCode();
        return n += null == this.rangeClassNames ? 0 : ((Object)this.rangeClassNames).hashCode();
    }

    public static List buildPropertyInfoList(OWLModel oWLModel, String string) throws SWRLRuleEngineBridgeException {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        RDFProperty rDFProperty = oWLModel.getRDFProperty(string);
        if (rDFProperty == null) {
            throw new InvalidPropertyNameException(string);
        }
        List list = PropertyInfo.rdfResources2NamesList(rDFProperty.getUnionDomain());
        List list2 = PropertyInfo.rdfResources2NamesList(rDFProperty.getUnionRangeClasses());
        for (RDFSClass rDFSClass : rDFProperty.getUnionDomain()) {
            for (Object e : rDFSClass.getInstances(true)) {
                PropertyInfo propertyInfo;
                Info info;
                IndividualInfo individualInfo;
                OWLIndividual oWLIndividual;
                if (!(e instanceof OWLIndividual) || !(oWLIndividual = (OWLIndividual)e).hasPropertyValue(rDFProperty)) continue;
                if (rDFProperty.hasObjectRange()) {
                    for (RDFObject rDFObject : oWLIndividual.getPropertyValues(rDFProperty)) {
                        individualInfo = new IndividualInfo(oWLIndividual.getName());
                        info = new IndividualInfo(rDFObject.getName());
                        propertyInfo = new PropertyInfo(string, individualInfo, (Argument)((Object)info), list, list2);
                        arrayList.add(propertyInfo);
                    }
                    continue;
                }
                for (RDFObject rDFObject : oWLIndividual.getPropertyValueLiterals(rDFProperty)) {
                    individualInfo = new IndividualInfo(oWLIndividual.getName());
                    info = new LiteralInfo(oWLModel, (RDFSLiteral)rDFObject);
                    propertyInfo = new PropertyInfo(string, individualInfo, (Argument)((Object)info), list, list2);
                    arrayList.add(propertyInfo);
                }
            }
        }
        return arrayList;
    }
}

