/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.LiteralConversionException;

public class LiteralInfo
extends Info
implements Argument {
    private Object value;

    public LiteralInfo(OWLModel oWLModel, RDFSLiteral rDFSLiteral) throws LiteralConversionException {
        super("<An RDFS-based literal>");
        RDFSDatatype rDFSDatatype = rDFSLiteral.getDatatype();
        if (rDFSDatatype == oWLModel.getXSDint() || rDFSDatatype == oWLModel.getXSDinteger()) {
            this.value = new Integer(rDFSLiteral.getInt());
        } else if (rDFSDatatype == oWLModel.getXSDshort()) {
            this.value = new Short(rDFSLiteral.getShort());
        } else if (rDFSDatatype == oWLModel.getXSDlong()) {
            this.value = new Long(rDFSLiteral.getLong());
        } else if (rDFSDatatype == oWLModel.getXSDboolean()) {
            this.value = new Boolean(rDFSLiteral.getBoolean());
        } else if (rDFSDatatype == oWLModel.getXSDfloat()) {
            this.value = new Float(rDFSLiteral.getFloat());
        } else if (rDFSDatatype == oWLModel.getXSDdouble()) {
            this.value = new Double(rDFSLiteral.getDouble());
        } else if (rDFSDatatype == oWLModel.getXSDstring()) {
            this.value = new String(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDtime()) {
            this.value = new Time(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDanyURI()) {
            this.value = new AnyURI(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDbase64Binary()) {
            this.value = new Base64Binary(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDdecimal()) {
            this.value = new Decimal(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDbyte()) {
            this.value = new Byte(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDduration()) {
            this.value = new Duration(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDdateTime()) {
            this.value = new DateTime(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDdate()) {
            this.value = new Date(rDFSLiteral.getString());
        } else {
            throw new LiteralConversionException("Cannot create LiteralInfo object for RDFS literal '" + rDFSLiteral.getString() + "' of type " + rDFSDatatype + ".");
        }
    }

    public LiteralInfo(String string) {
        super("<A string literal>");
        this.value = string;
    }

    public LiteralInfo(Number number) {
        super("<A number literal>");
        this.value = number;
    }

    public LiteralInfo(boolean bl) {
        super("<A boolean literal>");
        this.value = new Boolean(bl);
    }

    public LiteralInfo(int n) {
        super("<An integer literal>");
        this.value = new Integer(n);
    }

    public LiteralInfo(float f) {
        super("<A float literal>");
        this.value = new Float(f);
    }

    public LiteralInfo(double d) {
        super("<A double literal>");
        this.value = new Double(d);
    }

    public LiteralInfo(short s) {
        super("<A short literal>");
        this.value = new Short(s);
    }

    public LiteralInfo(ComplexXSDType complexXSDType) {
        super("<A complex XSD literal>");
        this.value = complexXSDType;
    }

    public int getInt() {
        return this.isInteger() ? (Integer)this.value : -1;
    }

    public boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.value : false;
    }

    public long getLong() {
        return this.isLong() ? (Long)this.value : -1L;
    }

    public float getFloat() {
        return this.isFloat() ? ((Float)this.value).floatValue() : -1.0f;
    }

    public double getDouble() {
        return this.isDouble() ? (Double)this.value : -1.0;
    }

    public short getShort() {
        return this.isShort() ? (Short)this.value : (short)-1;
    }

    public String getString() {
        return this.isString() ? (String)this.value : null;
    }

    public Time getTime() {
        return this.isTime() ? (Time)this.value : null;
    }

    public Date getDate() {
        return this.isDate() ? (Date)this.value : null;
    }

    public DateTime getDateTime() {
        return this.isDateTime() ? (DateTime)this.value : null;
    }

    public Duration getDuration() {
        return this.isDuration() ? (Duration)this.value : null;
    }

    public AnyURI getAnyURI() {
        return this.isAnyURI() ? (AnyURI)this.value : null;
    }

    public Base64Binary getBase64Binary() {
        return this.isBase64Binary() ? (Base64Binary)this.value : null;
    }

    public Decimal getDecimal() {
        return this.isDecimal() ? (Decimal)this.value : null;
    }

    public Byte getByte() {
        return this.isByte() ? (Byte)this.value : null;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isFloat() {
        return this.value instanceof Float;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public boolean isShort() {
        return this.value instanceof Short;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isTime() {
        return this.value instanceof Time;
    }

    public boolean isDate() {
        return this.value instanceof Date;
    }

    public boolean isDateTime() {
        return this.value instanceof DateTime;
    }

    public boolean isDuration() {
        return this.value instanceof Duration;
    }

    public boolean isAnyURI() {
        return this.value instanceof AnyURI;
    }

    public boolean isBase64Binary() {
        return this.value instanceof Base64Binary;
    }

    public boolean isDecimal() {
        return this.value instanceof Decimal;
    }

    public boolean isByte() {
        return this.value instanceof Byte;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        LiteralInfo literalInfo = (LiteralInfo)object;
        return (this.getName() == literalInfo.getName() || this.getName() != null && this.getName().equals(literalInfo.getName())) && this.value != null && literalInfo.value != null && this.value.toString().equals(literalInfo.value.toString());
    }

    public int hashCode() {
        int n = 66;
        n += null == this.getName() ? 0 : this.getName().hashCode();
        return n += null == this.value ? 0 : this.value.toString().hashCode();
    }

    public class Byte
    extends ComplexXSDType {
        public Byte(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Byte literal.");
            }
        }
    }

    public class Decimal
    extends ComplexXSDType {
        public Decimal(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Decimal literal.");
            }
        }
    }

    public class Base64Binary
    extends ComplexXSDType {
        public Base64Binary(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Base64Binary literal.");
            }
        }
    }

    public class AnyURI
    extends ComplexXSDType {
        public AnyURI(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for AnyURI literal.");
            }
        }
    }

    public class Duration
    extends ComplexXSDType {
        public Duration(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Duration literal.");
            }
        }
    }

    public class DateTime
    extends ComplexXSDType {
        public DateTime(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for DateTime literal.");
            }
        }
    }

    public class Date
    extends ComplexXSDType {
        public Date(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Time literal.");
            }
        }
    }

    public class Time
    extends ComplexXSDType {
        public Time(String string) throws LiteralConversionException {
            super(string);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Time literal.");
            }
        }
    }

    public abstract class ComplexXSDType {
        private String content;

        public ComplexXSDType(String string) throws LiteralConversionException {
            this.content = string;
            this.validate();
        }

        public String getContent() {
            return this.content;
        }

        protected abstract void validate() throws LiteralConversionException;
    }
}

