/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidIndividualNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class IndividualInfo
extends Info
implements Argument {
    private Collection classNames;

    public IndividualInfo(OWLIndividual oWLIndividual) throws SWRLRuleEngineBridgeException {
        super(oWLIndividual.getName());
        this.classNames = this.getDefiningClassNames(oWLIndividual);
    }

    public IndividualInfo(OWLModel oWLModel, String string) throws SWRLRuleEngineBridgeException {
        super(string);
        OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(string);
        if (oWLIndividual == null) {
            throw new InvalidIndividualNameException(string);
        }
        this.classNames = this.getDefiningClassNames(oWLIndividual);
    }

    public IndividualInfo(String string, String string2) throws SWRLRuleEngineBridgeException {
        super(string);
        this.classNames = new ArrayList();
        this.classNames.add(string2);
    }

    public IndividualInfo(String string) {
        super(string);
        this.classNames = new ArrayList();
    }

    public Collection getClassNames() {
        return this.classNames;
    }

    public void write2OWL(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(this.getName());
        if (oWLIndividual == null) {
            throw new InvalidIndividualNameException(this.getName());
        }
        for (String string : this.getClassNames()) {
            OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
            if (oWLIndividual.hasRDFType(oWLNamedClass)) continue;
            oWLIndividual.addRDFType(oWLNamedClass);
        }
    }

    public String toString() {
        return "Individual(name: " + this.getName() + ", classNames: " + this.classNames + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        IndividualInfo individualInfo = (IndividualInfo)object;
        return (this.getName() == individualInfo.getName() || this.getName() != null && this.getName().equals(individualInfo.getName())) && (this.classNames == individualInfo.classNames || this.classNames != null && ((Object)this.classNames).equals(individualInfo.classNames));
    }

    public int hashCode() {
        int n = 7;
        n += null == this.getName() ? 0 : this.getName().hashCode();
        return n += null == this.classNames ? 0 : ((Object)this.classNames).hashCode();
    }

    private Collection getDefiningClassNames(OWLIndividual oWLIndividual) throws SWRLRuleEngineBridgeException {
        HashSet<String> hashSet = new HashSet<String>();
        for (RDFSClass rDFSClass : oWLIndividual.getRDFTypes()) {
            hashSet.add(rDFSClass.getName());
            for (RDFSClass rDFSClass2 : rDFSClass.getNamedSuperclasses(true)) {
                hashSet.add(rDFSClass2.getName());
            }
        }
        return hashSet;
    }
}

