/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.storage.KnowledgeBaseCopier;

public class OWL2OWLCopier
extends KnowledgeBaseCopier {
    private OWLModel source;
    private OWLModel target;

    public OWL2OWLCopier(OWLModel oWLModel, OWLModel oWLModel2) {
        super(oWLModel, oWLModel2);
        this.source = oWLModel;
        this.target = oWLModel2;
    }

    protected void createClses() {
        for (OWLNamedClass oWLNamedClass : this.source.getUserDefinedOWLNamedClasses()) {
            this.getNewCls(oWLNamedClass);
        }
        super.createClses();
    }

    protected void createFacetOverrides(Cls cls) {
        if (cls instanceof OWLRestriction) {
            super.createFacetOverrides(cls);
        }
    }

    protected Instance getNewInstance(Instance instance) {
        if (instance instanceof OWLOntology && instance.equals(this.source.getDefaultOWLOntology())) {
            return this.target.getDefaultOWLOntology();
        }
        return super.getNewInstance(instance);
    }

    protected void setInitialOwnSlotValues(Instance instance) {
        if (instance instanceof OWLRestriction) {
            OWLRestriction oWLRestriction = (OWLRestriction)instance;
            OWLRestriction oWLRestriction2 = (OWLRestriction)this.getNewInstance(oWLRestriction);
            this.createFacetOverrides(oWLRestriction);
            this.log("+ Initialized OWLRestriction " + oWLRestriction2.getBrowserText());
        }
    }

    protected void setOwnSlotValues(Frame frame, Instance instance, Slot slot) {
        if (frame instanceof OWLOntology && slot.getName().equals(":OWL-ONTOLOGY-PREFIXES") && frame.equals(this.target.getDefaultOWLOntology())) {
            OWLOntology oWLOntology = (OWLOntology)frame;
            for (String string : this.source.getNamespaceManager().getPrefixes()) {
                String string2 = this.source.getNamespaceManager().getNamespaceForPrefix(string);
                this.target.getNamespaceManager().setPrefix(string2, string);
            }
            this.target.getNamespaceManager().setDefaultNamespace(this.source.getNamespaceManager().getDefaultNamespace());
        } else {
            super.setOwnSlotValues(frame, instance, slot);
        }
    }
}

