/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.util.Log;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLBaseExtractor {
    private InputStream is;
    private URI xmlBase;
    private String rootElementName;
    private String defaultNamespace;

    public XMLBaseExtractor(InputStream inputStream) {
        this.is = inputStream;
        this.xmlBase = null;
    }

    public URI getXMLBase() {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler((ContentHandler)new MyHandler());
        try {
            sAXParser.parse(new InputSource(this.is));
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
        }
        return this.xmlBase;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private class MyHandler
    implements ContentHandler {
        private boolean startElement;

        private MyHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.startElement) {
                XMLBaseExtractor.this.rootElementName = string3;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("xml:base")) {
                        URI uRI = null;
                        try {
                            uRI = new URI(attributes.getValue(i));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
                        }
                        XMLBaseExtractor.this.xmlBase = uRI;
                        continue;
                    }
                    if (!attributes.getLocalName(i).equals("xmlns")) continue;
                    XMLBaseExtractor.this.defaultNamespace = attributes.getValue(i);
                }
            } else {
                throw new SAXException("No xml:base");
            }
            this.startElement = true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    }
}

