/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RepositoryUtil {
    public static final String FORCE_READ_ONLY_FLAG = "forceReadOnly";

    public static boolean isForcedToBeReadOnly(String string) {
        return RepositoryUtil.getBooleanProperty(FORCE_READ_ONLY_FLAG, string);
    }

    public static boolean getBooleanProperty(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string3.substring(0, string3.indexOf(61));
                String string5 = string3.substring(string3.indexOf(61) + 1, string3.length());
                if (!string4.equals(string)) continue;
                return Boolean.valueOf(string5);
            }
        }
        return false;
    }

    public static boolean createImportLocalCopy(OWLModel oWLModel, URI uRI, File file) throws IOException {
        Repository repository = oWLModel.getRepositoryManager().getRepository(uRI);
        if (repository != null) {
            String string;
            InputStream inputStream = repository.getInputStream(uRI);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            while ((string = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
            oWLModel.getRepositoryManager().addProjectRepository(0, new LocalFileRepository(file));
            return true;
        }
        return false;
    }

    public static boolean isDublinCoreRedirectedToDLVersion(RepositoryManager repositoryManager) {
        Iterator iterator = repositoryManager.getProjectRepositories().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof DublinCoreDLVersionRedirectRepository)) continue;
            return true;
        }
        return false;
    }

    public static void setDublinCoreRedirectedToDLVersion(RepositoryManager repositoryManager, boolean bl) {
        block2: {
            block1: {
                if (!bl) break block1;
                if (RepositoryUtil.isDublinCoreRedirectedToDLVersion(repositoryManager)) break block2;
                repositoryManager.addProjectRepository(0, new DublinCoreDLVersionRedirectRepository());
                break block2;
            }
            for (Repository repository : repositoryManager.getProjectRepositories()) {
                if (!(repository instanceof DublinCoreDLVersionRedirectRepository)) continue;
                repositoryManager.remove(repository);
                break;
            }
        }
    }
}

