/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (string.trim().startsWith("http:")) {
            try {
                new URL(string);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("[URL Repository Factory] Could not create a HTTP repository because the specified URL, " + string + " was malformed.");
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            return new HTTPRepository(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

