/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

public class DublinCoreDLVersionRedirectRepository
implements Repository {
    private URI dublinCoreOntologyURI;
    private URL redirectURL;
    public static final String DESCRIPTOR = "[Dublin Core DL Redirect]";
    public static final String DC = "http://purl.org/dc/elements/1.1/";
    public static final String DC_ALT = "http://protege.stanford.edu/plugins/owl/dc/protege-dc.owl";

    public DublinCoreDLVersionRedirectRepository() {
        try {
            this.dublinCoreOntologyURI = new URI(DC);
            this.redirectURL = new URL(DC_ALT);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
    }

    public boolean contains(URI uRI) {
        return this.dublinCoreOntologyURI.equals(uRI);
    }

    public void refresh() {
    }

    public Collection getOntologies() {
        return Collections.singleton(this.dublinCoreOntologyURI);
    }

    public InputStream getInputStream(URI uRI) throws IOException {
        return ProtegeOWLParser.getInputStream(this.redirectURL);
    }

    public boolean isWritable(URI uRI) {
        return false;
    }

    public OutputStream getOutputStream(URI uRI) throws IOException {
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getRepositoryDescription() {
        return "Dublin Core DL Version";
    }

    public String getOntologyLocationDescription(URI uRI) {
        return "Redirect to " + this.redirectURL.toString();
    }

    public String getRepositoryDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        return this.redirectURL.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DublinCoreDLVersionRedirectRepository;
    }
}

