/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ResourceCopier
extends OWLModelVisitorAdapter {
    private RDFObject copy;
    protected static String[] doNotCopySlots = new String[]{":DIRECT-SUBCLASSES", ":DIRECT-SUPERCLASSES", "rdfs:subClassOf", "owl:equivalentClass", ":NAME"};
    private Collection doNotCopySlotsList;
    private OWLModel owlModel;

    public RDFObject getCopy() {
        return this.copy;
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        this.visitResourceToBeReferenced(oWLNamedClass);
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        this.visitResourceToBeReferenced(oWLIndividual);
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        this.visitResourceToBeReferenced(oWLObjectProperty);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        this.visitResourceToBeReferenced(oWLDatatypeProperty);
    }

    public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.visitResourceToBeReferenced(rDFSNamedClass);
    }

    public void visitRDFIndividual(RDFIndividual rDFIndividual) {
        this.visitResourceToBeReferenced(rDFIndividual);
    }

    public void visitRDFProperty(RDFProperty rDFProperty) {
        this.visitResourceToBeReferenced(rDFProperty);
    }

    public void visitRDFDatatype(RDFSDatatype rDFSDatatype) {
        this.visitResourceToBeReferenced(rDFSDatatype);
    }

    protected void visitResourceToBeReferenced(RDFResource rDFResource) {
        if (!rDFResource.isSystem()) {
            if (rDFResource.getOWLModel() != this.owlModel) {
                this.owlModel = rDFResource.getOWLModel();
            }
            if (this.owlModel.getDefaultOWLOntology().getImports().size() > 0) {
                TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
                TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(rDFResource);
                TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
                if (tripleStore2 != tripleStore) {
                    String string = tripleStore.getDefaultNamespace();
                    String string2 = string.substring(0, string.length() - 1);
                    OWLOntology oWLOntology = OWLUtil.getActiveOntology(this.owlModel);
                    if (!oWLOntology.getImports().contains(string2)) {
                        oWLOntology.addImports(string2);
                    }
                }
            }
        }
        this.copy = rDFResource;
    }

    public void visitRDFSLiteral(RDFSLiteral rDFSLiteral) {
        this.copy = rDFSLiteral;
    }

    public void visitRDFUntypedResource(RDFUntypedResource rDFUntypedResource) {
        this.copy = rDFUntypedResource;
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        this.copyMultipleSlotValues(oWLUnionClass, oWLUnionClass.getOWLModel().createOWLUnionClass());
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        this.copyMultipleSlotValues(oWLIntersectionClass, oWLIntersectionClass.getOWLModel().createOWLIntersectionClass());
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        this.copyMultipleSlotValues(oWLEnumeratedClass, oWLEnumeratedClass.getOWLModel().createOWLEnumeratedClass());
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        this.copyMultipleSlotValues(oWLComplementClass, oWLComplementClass.getOWLModel().createOWLComplementClass());
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        this.copyMultipleSlotValues(oWLSomeValuesFrom, oWLSomeValuesFrom.getOWLModel().createOWLSomeValuesFrom());
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        this.copyMultipleSlotValues(oWLAllValuesFrom, oWLAllValuesFrom.getOWLModel().createOWLAllValuesFrom());
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.copyMultipleSlotValues(oWLCardinality, oWLCardinality.getOWLModel().createOWLCardinality());
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        this.copyMultipleSlotValues(oWLMaxCardinality, oWLMaxCardinality.getOWLModel().createOWLMaxCardinality());
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.copyMultipleSlotValues(oWLMinCardinality, oWLMinCardinality.getOWLModel().createOWLMinCardinality());
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        this.copyMultipleSlotValues(oWLHasValue, oWLHasValue.getOWLModel().createOWLHasValue());
    }

    public void visitRDFList(RDFList rDFList) {
        if (rDFList == rDFList.getOWLModel().getRDFNil()) {
            this.copy = rDFList;
        } else {
            this.copyMultipleSlotValues(rDFList, rDFList.getOWLModel().createRDFList());
        }
    }

    public void visitOWLAllDifferent(OWLAllDifferent oWLAllDifferent) {
        this.copyMultipleSlotValues(oWLAllDifferent, oWLAllDifferent.getOWLModel().createOWLAllDifferent());
    }

    public void visitOWLDataRange(OWLDataRange oWLDataRange) {
        this.copyMultipleSlotValues(oWLDataRange, oWLDataRange.getOWLModel().createOWLDataRange());
    }

    public void visitOWLOntology(OWLOntology oWLOntology) {
        String string = null;
        int n = 2;
        do {
            string = oWLOntology.getName() + n;
            ++n;
        } while (oWLOntology.getOWLModel().getRDFResource(string) != null);
        this.copyMultipleSlotValues(oWLOntology, oWLOntology.getOWLModel().createOWLOntology(string));
    }

    public void copyMultipleSlotValues(RDFResource rDFResource, RDFResource rDFResource2) {
        if (rDFResource.getOWLModel() != this.owlModel) {
            this.owlModel = rDFResource.getOWLModel();
            this.doNotCopySlotsList = new HashSet();
            for (int i = 0; i < doNotCopySlots.length; ++i) {
                this.doNotCopySlotsList.add(this.owlModel.getSlot(doNotCopySlots[i]));
            }
        }
        for (Slot slot : rDFResource.getOwnSlots()) {
            if (this.doNotCopySlotsList.contains(slot)) continue;
            this.copySlotValues(rDFResource, rDFResource2, slot);
        }
        this.copy = rDFResource2;
    }

    public void copySlotValues(RDFResource rDFResource, RDFResource rDFResource2, Slot slot) {
        List list = rDFResource.getDirectOwnSlotValues(slot);
        if (list != null && list.size() > 0) {
            ArrayList arrayList = new ArrayList(list.size());
            for (Object object : list) {
                if (object instanceof RDFObject) {
                    ((RDFObject)object).accept(this);
                    object = this.copy;
                }
                if (object == null) continue;
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                rDFResource2.setDirectOwnSlotValues(slot, arrayList);
            }
        }
    }
}

