/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class ImportHelper {
    private JenaOWLModel owlModel;
    private Set ontologyURIs;

    public ImportHelper(JenaOWLModel jenaOWLModel) {
        this.owlModel = jenaOWLModel;
        this.ontologyURIs = new HashSet();
    }

    public void addImport(URI uRI) {
        this.ontologyURIs.add(uRI);
    }

    public void importOntologies() throws Exception {
        this.importOntologies(true);
    }

    public void importOntologies(boolean bl) throws Exception {
        HashSet<URI> hashSet = new HashSet<URI>();
        for (URI uRI : this.ontologyURIs) {
            if (this.owlModel.getAllImports().contains(uRI.toString())) continue;
            ProtegeOWLParser.addImport(this.owlModel, uRI);
            for (OWLOntology oWLOntology : this.owlModel.getOWLOntologies()) {
                TripleStore tripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
                if (this.owlModel.getTripleStoreModel().getHomeTripleStore(oWLOntology) != tripleStore) continue;
                oWLOntology.addImports(uRI);
                break;
            }
            hashSet.add(uRI);
        }
        if (hashSet.size() > 0 && ProtegeOWLParser.inUI) {
            this.owlModel.getTripleStoreModel().updateEditableResourceState();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(this.owlModel);
            if (bl) {
                ProtegeUI.reloadUI(this.owlModel);
            }
        }
    }
}

