/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureAxiomFactory {
    public static OWLAllValuesFrom addClosureAxiom(OWLNamedClass oWLNamedClass, OWLExistentialRestriction oWLExistentialRestriction) {
        OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)oWLExistentialRestriction.getOnProperty();
        OWLModel oWLModel = oWLExistentialRestriction.getOWLModel();
        OWLAnonymousClass oWLAnonymousClass = oWLExistentialRestriction.getExpressionRoot();
        OWLNamedClass oWLNamedClass2 = oWLAnonymousClass.getOwner();
        List list = ClosureAxiomFactory.getFillerStrings(oWLNamedClass2, oWLObjectProperty);
        RDFSClass rDFSClass = ClosureAxiomFactory.getFiller(list, oWLModel);
        OWLAllValuesFrom oWLAllValuesFrom = oWLModel.createOWLAllValuesFrom((RDFProperty)oWLObjectProperty, rDFSClass);
        if (oWLAnonymousClass instanceof OWLIntersectionClass) {
            if (oWLNamedClass2.equals(oWLNamedClass)) {
                OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)oWLAnonymousClass.createClone();
                oWLIntersectionClass.addOperand(oWLAllValuesFrom);
                oWLAnonymousClass.delete();
                oWLNamedClass.addEquivalentClass(oWLIntersectionClass);
            } else {
                oWLNamedClass.addSuperclass(oWLAllValuesFrom);
            }
            return oWLAllValuesFrom;
        }
        if (oWLNamedClass2.hasEquivalentClass(oWLExistentialRestriction) && oWLNamedClass2.equals(oWLNamedClass)) {
            OWLIntersectionClass oWLIntersectionClass = oWLModel.createOWLIntersectionClass();
            oWLIntersectionClass.addOperand(oWLExistentialRestriction.createClone());
            oWLIntersectionClass.addOperand(oWLAllValuesFrom);
            oWLExistentialRestriction.delete();
            oWLNamedClass.addEquivalentClass(oWLIntersectionClass);
        } else {
            oWLNamedClass.addSuperclass(oWLAllValuesFrom);
        }
        return oWLAllValuesFrom;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass oWLNamedClass, OWLExistentialRestriction oWLExistentialRestriction) {
        Iterator iterator = ClosureAxiomFactory.getClosureAxiomCandidates(oWLNamedClass, oWLExistentialRestriction);
        if (iterator.hasNext()) {
            return (OWLAllValuesFrom)iterator.next();
        }
        return null;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty) {
        Iterator<OWLAllValuesFrom> iterator = ClosureAxiomFactory.getUniversals(oWLNamedClass);
        while (iterator.hasNext()) {
            OWLAllValuesFrom oWLAllValuesFrom = iterator.next();
            if (oWLAllValuesFrom.getOnProperty() != rDFProperty && !rDFProperty.isSubpropertyOf(oWLAllValuesFrom.getOnProperty(), true)) continue;
            RDFResource rDFResource = oWLAllValuesFrom.getFiller();
            if (rDFResource instanceof RDFSNamedClass) {
                return oWLAllValuesFrom;
            }
            if (!(rDFResource instanceof OWLUnionClass)) continue;
            boolean bl = true;
            Iterator iterator2 = ((OWLUnionClass)rDFResource).getOperands().iterator();
            while (iterator2.hasNext() && bl) {
                if (iterator2.next() instanceof RDFSNamedClass) continue;
                bl = false;
            }
            if (!bl) continue;
            return oWLAllValuesFrom;
        }
        return null;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, RDFResource rDFResource) {
        Iterator<OWLAllValuesFrom> iterator = ClosureAxiomFactory.getUniversals(oWLNamedClass);
        while (iterator.hasNext()) {
            OWLAllValuesFrom oWLAllValuesFrom = iterator.next();
            RDFProperty rDFProperty2 = oWLAllValuesFrom.getOnProperty();
            if (rDFProperty2 != rDFProperty && !rDFProperty.isSubpropertyOf(rDFProperty2, true)) continue;
            RDFResource rDFResource2 = oWLAllValuesFrom.getFiller();
            if (rDFResource2 instanceof OWLUnionClass && ((OWLUnionClass)rDFResource2).getOperands().contains(rDFResource)) {
                return oWLAllValuesFrom;
            }
            if (!rDFResource2.equals(rDFResource)) continue;
            return oWLAllValuesFrom;
        }
        return null;
    }

    private static Iterator<OWLAllValuesFrom> getUniversals(OWLNamedClass oWLNamedClass) {
        ArrayList<OWLAllValuesFrom> arrayList = new ArrayList<OWLAllValuesFrom>();
        for (RDFSClass rDFSClass : oWLNamedClass.getSuperclasses(true)) {
            OWLAllValuesFrom oWLAllValuesFrom;
            if (!(rDFSClass instanceof OWLAllValuesFrom) || (oWLAllValuesFrom = (OWLAllValuesFrom)rDFSClass).getEquivalentClasses().contains(oWLNamedClass)) continue;
            arrayList.add(oWLAllValuesFrom);
        }
        return arrayList.iterator();
    }

    private static Iterator getClosureAxiomCandidates(OWLNamedClass oWLNamedClass, OWLExistentialRestriction oWLExistentialRestriction) {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        OWLAnonymousClass oWLAnonymousClass = oWLExistentialRestriction.getExpressionRoot();
        if (oWLAnonymousClass instanceof OWLIntersectionClass) {
            Iterator iterator = ((OWLIntersectionClass)oWLAnonymousClass).listOperands();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                if (!(rDFSClass instanceof OWLAllValuesFrom)) continue;
                arrayList.add(rDFSClass);
            }
        } else {
            for (RDFSClass rDFSClass : oWLNamedClass.getSuperclasses(true)) {
                OWLAllValuesFrom oWLAllValuesFrom;
                if (!(rDFSClass instanceof OWLAllValuesFrom) || (oWLAllValuesFrom = (OWLAllValuesFrom)rDFSClass).getEquivalentClasses().contains(oWLNamedClass)) continue;
                arrayList.add(oWLAllValuesFrom);
            }
        }
        return arrayList.iterator();
    }

    private static RDFSClass getFiller(List list, OWLModel oWLModel) {
        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
        RDFSClass rDFSClass = null;
        if (list.size() == 1) {
            try {
                String string = (String)list.iterator().next();
                rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        } else {
            OWLUnionClass oWLUnionClass = oWLModel.createOWLUnionClass();
            for (String string : list) {
                try {
                    RDFSClass rDFSClass2 = oWLClassParser.parseClass(oWLModel, string);
                    oWLUnionClass.addOperand(rDFSClass2);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                }
            }
            rDFSClass = oWLUnionClass;
        }
        return rDFSClass;
    }

    private static List getFillerStrings(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty) {
        HashSet<String> hashSet = new HashSet<String>();
        for (OWLRestriction oWLRestriction : oWLNamedClass.getRestrictions(false)) {
            if (!(oWLRestriction instanceof OWLExistentialRestriction) || !rDFProperty.equals(oWLRestriction.getOnProperty())) continue;
            String string = oWLRestriction.getFillerText();
            if (oWLRestriction instanceof OWLSomeValuesFrom) {
                hashSet.add(string);
                continue;
            }
            if (!(oWLRestriction instanceof OWLHasValue)) continue;
            hashSet.add("{" + string + "}");
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }
}

