/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

class OWLDeprecatedClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    OWLDeprecatedClassPostProcessor(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.kb = oWLModel;
        this.updateDeprecatedClasses();
    }

    private void updateDeprecatedClasses() {
        Slot slot = this.kb.getSlot(":DIRECT-TYPE");
        Slot slot2 = this.kb.getSlot(":DIRECT-INSTANCES");
        RDFProperty rDFProperty = this.owlModel.getRDFTypeProperty();
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("owl:DeprecatedClass");
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        Iterator iterator = tripleStoreModel.listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = (TripleStore)iterator.next();
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            Set set = narrowFrameStore.getFrames((Slot)rDFProperty, null, false, (Object)rDFSNamedClass);
            for (Cls cls : set) {
                if (cls.getDirectTypes().size() == 1) {
                    OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClassClass();
                    if (!narrowFrameStore.getValues((Frame)cls, (Slot)rDFProperty, null, false).contains(oWLNamedClass)) {
                        narrowFrameStore.addValues((Frame)cls, (Slot)rDFProperty, null, false, Collections.singleton(oWLNamedClass));
                    }
                    narrowFrameStore.addValues((Frame)cls, slot, null, false, Collections.singleton(oWLNamedClass));
                    narrowFrameStore.addValues((Frame)oWLNamedClass, slot2, null, false, Collections.singleton(cls));
                }
                narrowFrameStore.removeValue((Frame)cls, slot, null, false, (Object)rDFSNamedClass);
                narrowFrameStore.removeValue((Frame)rDFSNamedClass, slot2, null, false, (Object)cls);
                narrowFrameStore.addValues((Frame)cls, slot, null, false, Collections.singleton(rDFSNamedClass));
                narrowFrameStore.addValues((Frame)rDFSNamedClass, slot2, null, false, Collections.singleton(cls));
            }
            OWLJavaFactoryUpdater.run(this.owlModel, set);
        }
    }
}

