/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLComplementClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLUnionClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddAnonymousClassPropertyPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddOWLInverseOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFSSubClassOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFSSubPropertyOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFTypePropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTripleStore
implements ProtegeTripleAdder,
TripleStore {
    private Map addPropertyValueHandlers = new HashMap();
    private Slot directInstancesSlot;
    private Slot directTypesSlot;
    protected NarrowFrameStore frameStore;
    protected Slot nameSlot;
    protected OWLModel owlModel;
    protected TripleStoreModel tripleStoreModel;

    public AbstractTripleStore(OWLModel oWLModel, TripleStoreModel tripleStoreModel, NarrowFrameStore narrowFrameStore) {
        this.frameStore = narrowFrameStore;
        this.owlModel = oWLModel;
        this.tripleStoreModel = tripleStoreModel;
        OWLModel oWLModel2 = oWLModel;
        this.directTypesSlot = oWLModel2.getSlot(":DIRECT-TYPE");
        this.directInstancesSlot = oWLModel2.getSlot(":DIRECT-INSTANCES");
        this.nameSlot = oWLModel2.getSlot(":NAME");
        this.initAACHandler("owl:complementOf", "owl:ComplementClass", DefaultOWLComplementClass.class);
        this.initAACHandler("owl:intersectionOf", "owl:IntersectionClass", DefaultOWLIntersectionClass.class);
        this.initAACHandler("owl:unionOf", "owl:UnionClass", DefaultOWLUnionClass.class);
        this.initAACHandler("owl:cardinality", "owl:CardinalityRestriction", DefaultOWLCardinality.class);
        this.initAACHandler("owl:minCardinality", "owl:MinCardinalityRestriction", DefaultOWLMinCardinality.class);
        this.initAACHandler("owl:maxCardinality", "owl:MaxCardinalityRestriction", DefaultOWLMaxCardinality.class);
        this.initAACHandler("owl:allValuesFrom", "owl:AllValuesFromRestriction", DefaultOWLAllValuesFrom.class);
        this.initAACHandler("owl:someValuesFrom", "owl:SomeValuesFromRestriction", DefaultOWLSomeValuesFrom.class);
        this.initAACHandler("owl:hasValue", "owl:HasValueRestriction", DefaultOWLHasValue.class);
        this.initHandler("owl:inverseOf", new AddOWLInverseOfPropertyHandler(this, oWLModel2));
        this.initHandler("rdfs:subClassOf", new AddRDFSSubClassOfPropertyHandler(this, oWLModel2));
        this.initHandler("rdfs:subPropertyOf", new AddRDFSSubPropertyOfPropertyHandler(this, oWLModel2));
        this.initHandler("rdf:type", new AddRDFTypePropertyHandler(this, oWLModel2, tripleStoreModel, this));
    }

    public void add(Triple triple) {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        this.addValueFast(rDFResource, rDFProperty, object);
        AddPropertyValueHandler addPropertyValueHandler = (AddPropertyValueHandler)this.addPropertyValueHandlers.get(rDFProperty);
        if (addPropertyValueHandler != null) {
            addPropertyValueHandler.handleAdd(rDFResource, object);
        }
    }

    public boolean addValue(Instance instance, Slot slot, Object object) {
        Collection collection = this.getValues(instance, slot);
        if (!collection.contains(object)) {
            this.addValueFast(instance, slot, object);
            return true;
        }
        return false;
    }

    public void addValueFast(Instance instance, Slot slot, Object object) {
        this.frameStore.addValues((Frame)instance, slot, null, false, Collections.singleton(object));
    }

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        Collection collection = this.getValues(rDFResource, rDFProperty);
        if (collection != null) {
            if (object instanceof RDFSLiteral) {
                collection = rDFResource.getOWLModel().asRDFSLiterals(collection);
            }
            return collection.contains(object);
        }
        return false;
    }

    public String getDefaultNamespace() {
        return this.getNamespaceForPrefix("");
    }

    public String getName() {
        return this.frameStore.getName();
    }

    public RDFResource getHomeResource(String string) {
        Set set = this.frameStore.getFrames(this.nameSlot, null, false, (Object)string);
        if (set.isEmpty()) {
            return null;
        }
        return (RDFResource)set.iterator().next();
    }

    public String getNamespaceForPrefix(String string) {
        RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (rDFResource != null) {
            string = string + ":";
            RDFProperty rDFProperty = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List list = this.getNarrowFrameStore().getValues((Frame)rDFResource, (Slot)rDFProperty, null, false);
            for (String string2 : list) {
                if (!string2.startsWith(string)) continue;
                return string2.substring(string.length());
            }
        }
        return null;
    }

    public FrameID generateFrameID() {
        return this.frameStore.generateFrameID();
    }

    public NarrowFrameStore getNarrowFrameStore() {
        return this.frameStore;
    }

    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.tripleStoreModel.getSlotValues(instance, slot);
    }

    protected Collection getValues(Instance instance, Slot slot) {
        return this.frameStore.getValues((Frame)instance, slot, null, false);
    }

    public String getPrefix(String string) {
        RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (rDFResource != null) {
            String string2 = ":" + string;
            RDFProperty rDFProperty = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List list = this.getNarrowFrameStore().getValues((Frame)rDFResource, (Slot)rDFProperty, null, false);
            for (String string3 : list) {
                if (!string3.endsWith(string2)) continue;
                return string3.substring(0, string3.length() - string2.length());
            }
        }
        return null;
    }

    public Collection getPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (rDFResource != null) {
            RDFProperty rDFProperty = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List list = this.getNarrowFrameStore().getValues((Frame)rDFResource, (Slot)rDFProperty, null, false);
            for (String string : list) {
                int n = string.indexOf(58);
                arrayList.add(string.substring(0, n));
            }
        }
        return arrayList;
    }

    protected Collection getReferences(Object object) {
        return this.frameStore.getReferences(object);
    }

    private void initAACHandler(String string, String string2, Class clazz) {
        Cls cls = this.owlModel.getCls(string2);
        this.initHandler(string, new AddAnonymousClassPropertyPropertyHandler(this, cls, clazz, this.tripleStoreModel));
    }

    private void initHandler(String string, AddPropertyValueHandler addPropertyValueHandler) {
        this.addPropertyValueHandlers.put(this.owlModel.getRDFProperty(string), addPropertyValueHandler);
    }

    public Iterator listHomeResources() {
        Set set = this.frameStore.getFramesWithAnyValue(this.nameSlot, null, false);
        Collection collection = AbstractOWLModel.getRDFResources(this.owlModel, set);
        return collection.iterator();
    }

    public Iterator listObjects(RDFResource rDFResource, RDFProperty rDFProperty) {
        return this.getValues(rDFResource, rDFProperty).iterator();
    }

    public Iterator listSubjects(RDFProperty rDFProperty) {
        Set set = this.frameStore.getFramesWithAnyValue((Slot)rDFProperty, null, false);
        return set.iterator();
    }

    public Iterator listSubjects(RDFProperty rDFProperty, Object object) {
        if (object instanceof DefaultRDFSLiteral && (object = DefaultRDFSLiteral.getPlainValueIfPossible(object)) instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        return this.frameStore.getFrames((Slot)rDFProperty, null, false, object).iterator();
    }

    public Iterator listTriplesWithObject(RDFObject rDFObject) {
        ArrayList<DefaultTriple> arrayList;
        Object object = rDFObject;
        if (rDFObject instanceof DefaultRDFSLiteral) {
            arrayList = ((DefaultRDFSLiteral)rDFObject).getPlainValue();
            object = arrayList == null ? ((DefaultRDFSLiteral)rDFObject).getRawValue() : arrayList;
        }
        arrayList = new ArrayList<DefaultTriple>();
        Collection collection = this.getReferences(object);
        for (Reference reference : collection) {
            if (!(reference.getFrame() instanceof RDFResource) || !(reference.getSlot() instanceof RDFProperty) || Model.SlotID.DIRECT_INSTANCES.equals((Object)reference.getSlot().getFrameID())) continue;
            DefaultTriple defaultTriple = new DefaultTriple((RDFResource)reference.getFrame(), (RDFProperty)reference.getSlot(), rDFObject);
            arrayList.add(defaultTriple);
        }
        return arrayList.iterator();
    }

    public Iterator listTriplesWithSubject(RDFResource rDFResource) {
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        Iterator iterator = rDFResource.getOWLModel().listRDFProperties();
        while (iterator.hasNext()) {
            RDFProperty rDFProperty = (RDFProperty)iterator.next();
            Iterator iterator2 = this.listObjects(rDFResource, rDFProperty);
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                DefaultTriple defaultTriple = new DefaultTriple(rDFResource, rDFProperty, e);
                arrayList.add(defaultTriple);
            }
        }
        return arrayList.iterator();
    }

    public void remove(Triple triple) {
        this.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        if (rDFProperty.equals(rDFResource.getOWLModel().getRDFTypeProperty())) {
            this.removeDirectType(rDFResource, object);
        }
        this.removeValue(rDFResource, rDFProperty, object);
    }

    public void setName(String string) {
        this.getNarrowFrameStore().setName(string);
    }

    private void removeDirectType(RDFResource rDFResource, Object object) {
        this.removeValue((Instance)object, this.directInstancesSlot, rDFResource);
        this.removeValue(rDFResource, this.directTypesSlot, object);
    }

    public void removePrefix(String string) {
        String string2 = this.getNamespaceForPrefix(string);
        if (string2 != null) {
            RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, this);
            RDFProperty rDFProperty = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            String string3 = string + ":" + string2;
            this.getNarrowFrameStore().removeValue((Frame)rDFResource, (Slot)rDFProperty, null, false, (Object)string3);
        }
    }

    protected void removeValue(Instance instance, Slot slot, Object object) {
        this.frameStore.removeValue((Frame)instance, slot, null, false, object);
    }

    public void setDefaultNamespace(String string) {
        this.setPrefix(string, "");
    }

    public void setDefaultNamespace(URI uRI) {
        this.setDefaultNamespace(uRI.toString());
    }

    public void setPrefix(String string, String string2) {
        this.removePrefix(string2);
        RDFResource rDFResource = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
        String string3 = string2 + ":" + string;
        this.getNarrowFrameStore().addValues((Frame)rDFResource, (Slot)rDFProperty, null, false, Collections.singleton(string3));
    }

    public void setPrefix(URI uRI, String string) {
        this.setPrefix(uRI.toString(), string);
    }

    public void setRDFResourceName(RDFResource rDFResource, String string) {
        NarrowFrameStore narrowFrameStore;
        List list;
        Iterator iterator;
        TripleStore tripleStore = this.tripleStoreModel.getHomeTripleStore(rDFResource);
        if (tripleStore != null && (iterator = (list = (narrowFrameStore = tripleStore.getNarrowFrameStore()).getValues((Frame)rDFResource, this.nameSlot, null, false)).iterator()).hasNext()) {
            String string2 = (String)iterator.next();
            narrowFrameStore.removeValue((Frame)rDFResource, this.nameSlot, null, false, (Object)string2);
        }
        this.addValueFast(rDFResource, this.nameSlot, string);
    }

    public void sortPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty, Comparator comparator) {
        TripleStoreUtil.sortSlotValues(this.getNarrowFrameStore(), rDFResource, rDFProperty, comparator);
    }

    public String toString() {
        return "TripleStore(" + this.getName() + ")";
    }

    public void dump() {
        System.out.println("Triples in " + this.getName());
        Iterator iterator = this.listTriples();
        while (iterator.hasNext()) {
            System.out.println(" - " + iterator.next());
        }
    }
}

