/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDateTimeType;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Assert;

public class XMLSchemaDatatypes {
    public static final String XML_LITERAL = "XMLLiteral";
    public static final XSDDatatype[] floatTypes = new XSDDatatype[]{XSDDatatype.XSDfloat, XSDDatatype.XSDdecimal, XSDDatatype.XSDdouble};
    public static final XSDDatatype[] integerTypes = new XSDDatatype[]{XSDDatatype.XSDint, XSDDatatype.XSDpositiveInteger, XSDDatatype.XSDnegativeInteger, XSDDatatype.XSDnonPositiveInteger, XSDDatatype.XSDnonNegativeInteger, XSDDatatype.XSDlong, XSDDatatype.XSDinteger, XSDDatatype.XSDshort, XSDDatatype.XSDbyte, XSDDatatype.XSDunsignedLong, XSDDatatype.XSDunsignedInt, XSDDatatype.XSDunsignedShort, XSDDatatype.XSDunsignedByte};
    public static final XSDDatatype[] stringTypes = new XSDDatatype[]{XSDDatatype.XSDstring, XSDDatatype.XSDanyURI, XSDDatatype.XSDdate, XSDDatatype.XSDdateTime, XSDDatatype.XSDduration, XSDDatatype.XSDgDay, XSDDatatype.XSDgMonth, XSDDatatype.XSDgMonthDay, XSDDatatype.XSDgYear, XSDDatatype.XSDgYearMonth, XSDDatatype.XSDtime, XSDDatatype.XSDnormalizedString, XSDDatatype.XSDtoken, XSDDatatype.XSDlanguage, XSDDatatype.XSDName, XSDDatatype.XSDNCName, XSDDatatype.XSDNMTOKEN, XSDDatatype.XSDID, XSDDatatype.XSDIDREF, XSDDatatype.XSDENTITY};
    private static final Hashtable alias2XSDDatatype = new Hashtable();
    private static final Hashtable uri2ValueTypeHashtable = new Hashtable();
    private static final Hashtable valueType2URIHashtable = new Hashtable();

    public static XSDDatatype[] getAllTypes() {
        ArrayList<XSDDatatype> arrayList = new ArrayList<XSDDatatype>();
        arrayList.addAll(Arrays.asList(stringTypes));
        arrayList.add(XSDDatatype.XSDboolean);
        arrayList.addAll(Arrays.asList(floatTypes));
        arrayList.addAll(Arrays.asList(integerTypes));
        return arrayList.toArray(new XSDDatatype[0]);
    }

    public static Date getDate(String string) {
        XSDDateTime xSDDateTime = (XSDDateTime)new XSDDateTimeType("dateTime").parse(string);
        Calendar calendar = xSDDateTime.asCalendar();
        calendar.setTimeZone(new GregorianCalendar().getTimeZone());
        return calendar.getTime();
    }

    public static String getDateString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(15) + calendar.get(16);
        calendar.add(14, n);
        DateXSDDateTime dateXSDDateTime = new DateXSDDateTime(calendar);
        return dateXSDDateTime.toString();
    }

    public static String getDateTimeString(Date date) {
        return XMLSchemaDatatypes.getDateString(date) + "T" + XMLSchemaDatatypes.getTimeString(date);
    }

    public static String getDefaultAlias(ValueType valueType) {
        return XMLSchemaDatatypes.getXSDDatatypeAlias(XMLSchemaDatatypes.getValueTypeURI(valueType));
    }

    public static String getDefaultDateValue() {
        return XMLSchemaDatatypes.getDateString(new Date());
    }

    public static String getDefaultDateTimeValue() {
        return XMLSchemaDatatypes.getDateTimeString(new Date());
    }

    public static String getDefaultTimeValue() {
        return XMLSchemaDatatypes.getTimeString(new Date());
    }

    public static XSDDatatype getDefaultXSDDatatype(ValueType valueType) {
        String string = XMLSchemaDatatypes.getDefaultAlias(valueType);
        return XMLSchemaDatatypes.getXSDDatatype(string);
    }

    public static List getSlotSymbols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = uri2ValueTypeHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String getTimeString(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String getTimeString(int n, int n2, int n3) {
        String string = "";
        string = string + (n < 10 ? "0" + n : "" + n);
        string = string + ":";
        string = string + (n2 < 10 ? "0" + n2 : "" + n2);
        string = string + ":";
        string = string + (n3 < 10 ? "0" + n3 : "" + n3);
        return string;
    }

    public static ValueType getValueType(String string) {
        ValueType valueType;
        if (string.equals(OWL.Class.getURI())) {
            return ValueType.CLS;
        }
        if (string.equals(RDFS.Literal.getURI())) {
            return ValueType.ANY;
        }
        if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
            return ValueType.STRING;
        }
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((valueType = (ValueType)uri2ValueTypeHashtable.get(string)) == null) {
            return ValueType.ANY;
        }
        return valueType;
    }

    public static String getValueTypeURI(ValueType valueType) {
        Assert.assertTrue((valueType != null && valueType != ValueType.INSTANCE && valueType != ValueType.CLS ? 1 : 0) != 0);
        if (valueType == ValueType.ANY) {
            System.err.println("Warning: Replaced illegal value type \"Any\" with \"String\"");
            valueType = ValueType.STRING;
        }
        return "http://www.w3.org/2001/XMLSchema#" + valueType2URIHashtable.get(valueType);
    }

    public static XSDDatatype getXSDDatatype(String string) {
        return (XSDDatatype)alias2XSDDatatype.get(string);
    }

    public static RDFDatatype getRDFDatatype(RDFSDatatype rDFSDatatype) {
        if (rDFSDatatype.equals(rDFSDatatype.getOWLModel().getRDFXMLLiteralType())) {
            return XMLLiteralType.theXMLLiteralType;
        }
        return XMLSchemaDatatypes.getXSDDatatype(rDFSDatatype);
    }

    public static XSDDatatype getXSDDatatype(RDFSDatatype rDFSDatatype) {
        if (rDFSDatatype.isSystem()) {
            return (XSDDatatype)alias2XSDDatatype.get(rDFSDatatype.getLocalName());
        }
        return XMLSchemaDatatypes.getXSDDatatype(rDFSDatatype.getBaseDatatype());
    }

    public static String getXSDDatatypeAlias(XSDDatatype xSDDatatype) {
        String string = xSDDatatype.getURI();
        return XMLSchemaDatatypes.getXSDDatatypeAlias(string);
    }

    public static String getXSDDatatypeAlias(String string) {
        int n = string.lastIndexOf(35);
        return string.substring(n + 1);
    }

    private static void initHashtables(ValueType valueType, String string) {
        if (valueType2URIHashtable.get(valueType) == null) {
            valueType2URIHashtable.put(valueType, string);
        }
        if (uri2ValueTypeHashtable.get(string) == null) {
            uri2ValueTypeHashtable.put(string, valueType);
        }
    }

    private static void initHashtables(ValueType valueType, XSDDatatype xSDDatatype) {
        String string = xSDDatatype.getURI();
        int n = string.lastIndexOf(35);
        String string2 = string.substring(n + 1);
        if (valueType != null) {
            XMLSchemaDatatypes.initHashtables(valueType, string2);
        }
        alias2XSDDatatype.put(string2, xSDDatatype);
    }

    private static void initHashtables(ValueType valueType, XSDDatatype[] xSDDatatypeArray) {
        for (int i = 0; i < xSDDatatypeArray.length; ++i) {
            XSDDatatype xSDDatatype = xSDDatatypeArray[i];
            XMLSchemaDatatypes.initHashtables(valueType, xSDDatatype);
        }
    }

    public static boolean isDateSlot(RDFProperty rDFProperty) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(rDFProperty, XSDDatatype.XSDdate);
    }

    public static boolean isDateTimeSlot(RDFProperty rDFProperty) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(rDFProperty, XSDDatatype.XSDdateTime);
    }

    public static boolean isTimeSlot(RDFProperty rDFProperty) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(rDFProperty, XSDDatatype.XSDtime);
    }

    public static boolean isXMLLiteralSlot(Slot slot) {
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            RDFResource rDFResource = rDFProperty.getRange();
            return rDFProperty.getOWLModel().getRDFXMLLiteralType().equals(rDFResource);
        }
        return false;
    }

    public static boolean isValidAlias(String string, ValueType valueType) {
        XSDDatatype xSDDatatype = XMLSchemaDatatypes.getXSDDatatype(string);
        if (xSDDatatype != null) {
            if (valueType == ValueType.INTEGER) {
                return Arrays.asList(integerTypes).contains(xSDDatatype);
            }
            if (valueType == ValueType.STRING) {
                return Arrays.asList(stringTypes).contains(xSDDatatype);
            }
            if (valueType == ValueType.FLOAT) {
                return Arrays.asList(floatTypes).contains(xSDDatatype);
            }
            if (valueType == ValueType.BOOLEAN) {
                return xSDDatatype.equals(XSDDatatype.XSDboolean);
            }
        }
        return false;
    }

    public static boolean isStringAlias(String string) {
        return Arrays.asList(stringTypes).contains(XMLSchemaDatatypes.getXSDDatatype(string));
    }

    public static boolean isXMLSchemaSlot(RDFProperty rDFProperty, XSDDatatype xSDDatatype) {
        RDFResource rDFResource = rDFProperty.getRange(true);
        return rDFProperty.getOWLModel().getRDFSDatatypeByURI(xSDDatatype.getURI()).equals(rDFResource);
    }

    public static boolean isNumericDatatype(String string) {
        XSDDatatype xSDDatatype;
        int n;
        for (n = 0; n < floatTypes.length; ++n) {
            xSDDatatype = floatTypes[n];
            if (!xSDDatatype.getURI().equals(string)) continue;
            return true;
        }
        for (n = 0; n < integerTypes.length; ++n) {
            xSDDatatype = integerTypes[n];
            if (!xSDDatatype.getURI().equals(string)) continue;
            return true;
        }
        return false;
    }

    static {
        XMLSchemaDatatypes.initHashtables(ValueType.BOOLEAN, XSDDatatype.XSDboolean);
        XMLSchemaDatatypes.initHashtables(ValueType.FLOAT, floatTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.INTEGER, integerTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.STRING, stringTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.SYMBOL, XSDDatatype.XSDstring);
        XMLSchemaDatatypes.initHashtables(null, XSDDatatype.XSDbase64Binary);
    }

    static class DateXSDDateTime
    extends XSDDateTime {
        DateXSDDateTime(Calendar calendar) {
            super(calendar);
            this.mask = (short)7;
        }
    }
}

