/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.AbstractNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OWLNamespaceManager
extends AbstractNamespaceManager {
    public static final String DEFAULT_DEFAULT_BASE = "http://www.owl-ontologies.com/unnamed.owl";
    public static final String DEFAULT_DEFAULT_NAMESPACE = "http://www.owl-ontologies.com/unnamed.owl#";
    private String defaultNamespace;
    private Slot prefixesSlot;
    private Map namespace2Prefix = new HashMap();
    private Map prefix2Namespace = new HashMap();
    private Collection systemPrefixes = new ArrayList();

    private void addPrefixes(Instance instance, boolean bl) {
        List list = instance.getDirectOwnSlotValues(this.prefixesSlot);
        for (String string : list) {
            int n = string.indexOf(58);
            if (n <= 0 && !bl) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.addPrefix(string2, string3);
        }
    }

    private void addPrefix(String string, String string2) {
        if (!this.prefix2Namespace.containsKey(string)) {
            this.prefix2Namespace.put(string, string2);
        }
        this.namespace2Prefix.put(string2, string);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getNamespaceForPrefix(String string) {
        return (String)this.prefix2Namespace.get(string);
    }

    public String getPrefix(String string) {
        return (String)this.namespace2Prefix.get(string);
    }

    public Collection getPrefixes() {
        HashSet hashSet = new HashSet(this.prefix2Namespace.keySet());
        hashSet.remove("");
        return hashSet;
    }

    public void init(OWLModel oWLModel) {
        super.init(oWLModel);
        this.prefixesSlot = oWLModel.getSlot(":OWL-ONTOLOGY-PREFIXES");
        this.update();
    }

    public boolean isModifiable(String string) {
        return !this.systemPrefixes.contains(string);
    }

    public static boolean isValidPrefix(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    public void removePrefix(String string) {
        this.removePrefixHelper(string);
        this.update();
        for (NamespaceManagerListener namespaceManagerListener : new ArrayList(this.getListeners())) {
            namespaceManagerListener.prefixRemoved(string);
        }
    }

    private void removePrefixHelper(String string) {
        String string2 = string + ":" + this.getNamespaceForPrefix(string);
        for (Instance instance : this.owlModel.getOWLOntologies()) {
            instance.removeOwnSlotValue(this.prefixesSlot, (Object)string2);
        }
    }

    public void setDefaultNamespace(String string) {
        String string2 = this.getDefaultNamespace();
        this.defaultNamespace = string;
        OWLOntology oWLOntology = this.owlModel.getDefaultOWLOntology();
        this.setDefaultNamespace(oWLOntology, string);
        for (NamespaceManagerListener namespaceManagerListener : new ArrayList(this.getListeners())) {
            namespaceManagerListener.defaultNamespaceChanged(string2, string);
        }
    }

    private void setDefaultNamespace(OWLOntology oWLOntology, String string) {
        List list = oWLOntology.getDirectOwnSlotValues(this.prefixesSlot);
        for (String string2 : list) {
            if (!string2.startsWith(":")) continue;
            oWLOntology.removeOwnSlotValue(this.prefixesSlot, string2);
            break;
        }
        oWLOntology.addOwnSlotValue(this.prefixesSlot, ":" + string);
        this.update();
    }

    public void setModifiable(String string, boolean bl) {
        if (bl) {
            this.systemPrefixes.remove(string);
        } else {
            this.systemPrefixes.add(string);
        }
    }

    public void setPrefix(String string, String string2) {
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        tripleStoreModel.setActiveTripleStore(tripleStoreModel.getTopTripleStore());
        String string3 = this.getPrefix(string);
        String string4 = this.getNamespaceForPrefix(string2);
        String string5 = string2 + ":" + string;
        OWLOntology oWLOntology = this.owlModel.getDefaultOWLOntology();
        if (string4 != null) {
            this.removePrefixHelper(string2);
            oWLOntology.addOwnSlotValue(this.prefixesSlot, string5);
            tripleStoreModel.setActiveTripleStore(tripleStore);
            this.update();
            for (NamespaceManagerListener namespaceManagerListener : new ArrayList(this.getListeners())) {
                namespaceManagerListener.namespaceChanged(string2, string4, string);
            }
        } else if (string3 != null) {
            this.removePrefixHelper(string3);
            oWLOntology.addOwnSlotValue(this.prefixesSlot, string5);
            tripleStoreModel.setActiveTripleStore(tripleStore);
            this.update();
            for (NamespaceManagerListener namespaceManagerListener : new ArrayList(this.getListeners())) {
                namespaceManagerListener.prefixChanged(string, string3, string2);
            }
        } else {
            oWLOntology.addOwnSlotValue(this.prefixesSlot, string5);
            tripleStoreModel.setActiveTripleStore(tripleStore);
            this.update();
            for (NamespaceManagerListener namespaceManagerListener : new ArrayList(this.getListeners())) {
                namespaceManagerListener.prefixAdded(string2);
            }
        }
    }

    public void update() {
        this.prefix2Namespace.clear();
        this.namespace2Prefix.clear();
        this.installDefaultNamespaces();
        ArrayList arrayList = this.owlModel.getOWLOntologies();
        Instance instance = null;
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        if (!arrayList.isEmpty()) {
            if (tripleStoreModel != null && this.owlModel instanceof JenaOWLModel) {
                TripleStore tripleStore = tripleStoreModel.getTopTripleStore();
                instance = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
            } else {
                instance = (Instance)arrayList.iterator().next();
            }
        }
        if (instance != null) {
            this.addPrefixes(instance, true);
            arrayList = new ArrayList(arrayList);
            arrayList.remove(instance);
        }
        for (Instance instance2 : arrayList) {
            this.addPrefixes(instance2, false);
        }
        this.defaultNamespace = this.getNamespaceForPrefix("");
        if (this.defaultNamespace == null) {
            this.defaultNamespace = DEFAULT_DEFAULT_NAMESPACE;
        }
    }

    private void installDefaultNamespaces() {
        this.addPrefix("owl", OWL.getURI());
        this.addPrefix("rdf", RDF.getURI());
        this.addPrefix("rdfs", RDFS.getURI());
        this.addPrefix("xsd", XSD.anyURI.getNameSpace());
    }
}

