/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultOWLNamedClass
extends DefaultRDFSNamedClass
implements OWLNamedClass {
    public DefaultOWLNamedClass(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLNamedClass() {
    }

    public void addDisjointClass(RDFSClass rDFSClass) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLDisjointWithProperty();
        this.addOwnSlotValue(rDFProperty, rDFSClass);
    }

    public void addEquivalentClass(RDFSClass rDFSClass) {
        if (!this.hasDirectSuperclass(rDFSClass)) {
            this.addDirectSuperclass(rDFSClass);
        }
        if (!rDFSClass.isSubclassOf(this)) {
            rDFSClass.addSuperclass(this);
        }
    }

    public void addInferredSuperclass(RDFSClass rDFSClass) {
        RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        this.addOwnSlotValue(rDFProperty, rDFSClass);
        if (rDFSClass instanceof OWLNamedClass) {
            RDFProperty rDFProperty2 = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
            rDFSClass.addOwnSlotValue(rDFProperty2, this);
        }
    }

    public OWLIndividual createOWLIndividual(String string) {
        return (OWLIndividual)this.createInstance(string);
    }

    public boolean equalsStructurally(RDFSClass rDFSClass) {
        return this.getName().equals(rDFSClass.getName());
    }

    public RDFResource getAllValuesFrom(RDFProperty rDFProperty) {
        Collection collection = this.getRestrictions(rDFProperty, true);
        for (OWLRestriction oWLRestriction : collection) {
            if (!(oWLRestriction instanceof OWLAllValuesFrom)) continue;
            return ((OWLAllValuesFrom)oWLRestriction).getAllValuesFrom();
        }
        return rDFProperty.getRange();
    }

    public Set getAssociatedProperties() {
        Set set = super.getAssociatedProperties();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (OWLRestriction oWLRestriction : this.getRestrictions(true)) {
            RDFProperty rDFProperty = oWLRestriction.getOnProperty();
            if ((oWLRestriction instanceof OWLCardinality || oWLRestriction instanceof OWLMaxCardinality) && ((OWLCardinalityBase)oWLRestriction).getCardinality() == 0) {
                hashSet.add(rDFProperty);
                hashSet.add(rDFProperty.getSubproperties(true));
                continue;
            }
            set.add(rDFProperty);
            set.addAll(rDFProperty.getSubproperties(true));
        }
        set.removeAll(hashSet);
        return set;
    }

    public int getClassificationStatus() {
        RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeClassificationStatusProperty();
        List list = this.getDirectOwnSlotValues(rDFProperty);
        if (list.size() == 0) {
            return 0;
        }
        return (Integer)list.iterator().next();
    }

    public Collection getDirectRestrictions() {
        ArrayList arrayList = new ArrayList();
        this.getDirectRestrictions(arrayList, this.getDirectSuperclasses().iterator());
        return arrayList;
    }

    public Object getHasValue(RDFProperty rDFProperty) {
        for (OWLRestriction oWLRestriction : this.getRestrictions(rDFProperty, true)) {
            if (!(oWLRestriction instanceof OWLHasValue)) continue;
            OWLHasValue oWLHasValue = (OWLHasValue)oWLRestriction;
            return oWLHasValue.getHasValue();
        }
        return null;
    }

    public Collection getInferredEquivalentClasses() {
        HashSet<Cls> hashSet = new HashSet<Cls>();
        for (Cls cls : this.getInferredSuperclasses()) {
            if (!this.getInferredSubclasses().contains(cls)) continue;
            hashSet.add(cls);
        }
        return hashSet;
    }

    private void getDirectRestrictions(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            if (cls instanceof OWLRestriction) {
                collection.add(cls);
                continue;
            }
            if (!(cls instanceof OWLIntersectionClass)) continue;
            OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)cls;
            this.getDirectRestrictions(collection, oWLIntersectionClass.getOperands().iterator());
        }
    }

    public Collection getInferredSubclasses() {
        RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
        return this.getDirectOwnSlotValues(rDFProperty);
    }

    public Collection getInferredSuperclasses() {
        RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        return this.getDirectOwnSlotValues(rDFProperty);
    }

    public int getMaxCardinality(RDFProperty rDFProperty) {
        if (rDFProperty.isFunctional()) {
            return 1;
        }
        Collection collection = this.getRestrictions(rDFProperty, true);
        for (OWLRestriction oWLRestriction : collection) {
            OWLCardinalityBase oWLCardinalityBase;
            if (!(oWLRestriction instanceof OWLCardinalityBase) || (oWLCardinalityBase = (OWLCardinalityBase)oWLRestriction).isQualified()) continue;
            if (oWLRestriction instanceof OWLMaxCardinality) {
                return ((OWLMaxCardinality)oWLRestriction).getCardinality();
            }
            if (!(oWLRestriction instanceof OWLCardinality)) continue;
            return ((OWLCardinality)oWLRestriction).getCardinality();
        }
        return -1;
    }

    public int getMinCardinality(RDFProperty rDFProperty) {
        Collection collection = this.getRestrictions(rDFProperty, true);
        for (OWLRestriction oWLRestriction : collection) {
            if (oWLRestriction instanceof OWLMinCardinality) {
                return ((OWLMinCardinality)oWLRestriction).getCardinality();
            }
            if (!(oWLRestriction instanceof OWLCardinality)) continue;
            return ((OWLCardinality)oWLRestriction).getCardinality();
        }
        return 0;
    }

    public Collection getRestrictions() {
        return this.getRestrictions(false);
    }

    public Icon getIcon() {
        if (!this.getOWLModel().getProject().isMultiUserClient() && this.isMetaCls()) {
            return super.getIcon();
        }
        ImageIcon imageIcon = this.getImageIconForNonMetaclass();
        if (this.isEditable()) {
            return imageIcon;
        }
        return OWLIcons.getReadOnlyClsIcon(imageIcon);
    }

    public String getIconName() {
        if (this.isMetaclass()) {
            return super.getIconName();
        }
        return this.getImageIconNameForNonMetaclass();
    }

    public ImageIcon getImageIcon() {
        if (this.isMetaCls()) {
            return super.getImageIcon();
        }
        return this.getImageIconForNonMetaclass();
    }

    private ImageIcon getImageIconForNonMetaclass() {
        String string = this.getImageIconNameForNonMetaclass();
        return OWLIcons.getImageIcon(string);
    }

    private String getImageIconNameForNonMetaclass() {
        String string = null;
        string = this.getPropertyValueCount(this.getOWLModel().getOWLEquivalentClassProperty()) == 0 ? "PrimitiveClass" : "DefinedOWLClass";
        if (!this.getOWLModel().getProject().isMultiUserClient()) {
            if (!this.isConsistent()) {
                string = string + "Inconsistent";
            }
            if (this.getSubclassesDisjoint()) {
                string = string + "SD";
            }
        }
        return string;
    }

    public Collection getRestrictions(boolean bl) {
        if (bl) {
            HashSet hashSet = new HashSet();
            ArrayList arrayList = new ArrayList();
            DefaultOWLNamedClass.getRestrictions(this, hashSet, arrayList);
            return arrayList;
        }
        return this.getDirectRestrictions();
    }

    public Collection getRestrictions(RDFProperty rDFProperty, boolean bl) {
        ArrayList<OWLRestriction> arrayList = new ArrayList<OWLRestriction>();
        Collection collection = this.getRestrictions(bl);
        for (OWLRestriction oWLRestriction : collection) {
            if (!rDFProperty.equals(oWLRestriction.getOnProperty())) continue;
            arrayList.add(oWLRestriction);
        }
        return arrayList;
    }

    private static void getRestrictions(OWLNamedClass oWLNamedClass, Set set, Collection collection) {
        set.add(oWLNamedClass);
        Collection collection2 = oWLNamedClass.getRestrictions(false);
        for (RDFSClass rDFSClass : collection2) {
            if (rDFSClass instanceof OWLAllValuesFrom) {
                if (DefaultOWLNamedClass.isOverloadedAllValuesFrom((OWLAllValuesFrom)rDFSClass, collection)) continue;
                collection.add(rDFSClass);
                continue;
            }
            if (rDFSClass instanceof OWLMinCardinality) {
                if (DefaultOWLNamedClass.isOverloadedMinCardinality((OWLMinCardinality)rDFSClass, collection)) continue;
                collection.add(rDFSClass);
                continue;
            }
            if (rDFSClass instanceof OWLMaxCardinality) {
                if (DefaultOWLNamedClass.isOverloadedMaxCardinality((OWLMaxCardinality)rDFSClass, collection)) continue;
                collection.add(rDFSClass);
                continue;
            }
            if (rDFSClass instanceof OWLCardinality) {
                if (DefaultOWLNamedClass.isOverloadedCardinality((OWLCardinality)rDFSClass, collection)) continue;
                collection.add(rDFSClass);
                continue;
            }
            collection.add(rDFSClass);
        }
        for (RDFSClass rDFSClass : oWLNamedClass.getNamedSuperclasses()) {
            if (!(rDFSClass instanceof OWLNamedClass) || set.contains(rDFSClass)) continue;
            DefaultOWLNamedClass.getRestrictions((OWLNamedClass)rDFSClass, set, collection);
        }
    }

    public RDFResource getSomeValuesFrom(RDFProperty rDFProperty) {
        Collection collection = this.getRestrictions(rDFProperty, true);
        for (OWLRestriction oWLRestriction : collection) {
            if (!(oWLRestriction instanceof OWLSomeValuesFrom)) continue;
            return ((OWLSomeValuesFrom)oWLRestriction).getSomeValuesFrom();
        }
        return null;
    }

    public boolean isConsistent() {
        return !this.getInferredSuperclasses().contains(this.getOWLModel().getOWLNothing());
    }

    private static boolean isOverloadedAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom, Collection collection) {
        RDFProperty rDFProperty = oWLAllValuesFrom.getOnProperty();
        for (OWLRestriction oWLRestriction : collection) {
            if (!(oWLRestriction instanceof OWLAllValuesFrom) || !oWLRestriction.getOnProperty().equals(rDFProperty)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedCardinality(OWLCardinality oWLCardinality, Collection collection) {
        RDFProperty rDFProperty = oWLCardinality.getOnProperty();
        for (OWLRestriction oWLRestriction : collection) {
            if (!rDFProperty.equals(oWLRestriction.getOnProperty()) || !(oWLRestriction instanceof OWLCardinality)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedMaxCardinality(OWLMaxCardinality oWLMaxCardinality, Collection collection) {
        RDFProperty rDFProperty = oWLMaxCardinality.getOnProperty();
        for (OWLRestriction oWLRestriction : collection) {
            if (!rDFProperty.equals(oWLRestriction.getOnProperty()) || !(oWLRestriction instanceof OWLCardinality) && !(oWLRestriction instanceof OWLMaxCardinality)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedMinCardinality(OWLMinCardinality oWLMinCardinality, Collection collection) {
        RDFProperty rDFProperty = oWLMinCardinality.getOnProperty();
        for (OWLRestriction oWLRestriction : collection) {
            if (!rDFProperty.equals(oWLRestriction.getOnProperty()) || !(oWLRestriction instanceof OWLCardinality) && !(oWLRestriction instanceof OWLMinCardinality)) continue;
            return true;
        }
        return false;
    }

    public boolean getSubclassesDisjoint() {
        Object object;
        RDFProperty rDFProperty = this.getOWLModel().getProtegeSubclassesDisjointProperty();
        if (rDFProperty != null && (object = this.getDirectOwnSlotValue(rDFProperty)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean hasNamedSuperclass() {
        return this.getNamedSuperclasses().size() > 0;
    }

    public boolean isDefinedClass() {
        return this.getDefinition() != null;
    }

    public boolean isFunctionalProperty(RDFProperty rDFProperty) {
        int n = this.getMaxCardinality(rDFProperty);
        return n == 0 || n == 1;
    }

    public boolean hasNamedSuperClass() {
        return this.hasNamedSuperclass();
    }

    public boolean isProbeClass() {
        Slot slot = this.getKnowledgeBase().getSlot(ProtegeNames.getProbeClassSlotName());
        if (slot instanceof OWLDatatypeProperty) {
            return Boolean.TRUE.equals(this.getDirectOwnSlotValue(slot));
        }
        return false;
    }

    public void removeDisjointClass(RDFSClass rDFSClass) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLDisjointWithProperty();
        this.removeOwnSlotValue(rDFProperty, rDFSClass);
        if (rDFSClass.isAnonymous()) {
            this.getKnowledgeBase().deleteCls((Cls)rDFSClass);
        }
    }

    public void removeEquivalentClass(RDFSClass rDFSClass) {
        if (rDFSClass instanceof OWLAnonymousClass) {
            this.removeDirectSuperclass(rDFSClass);
        } else {
            this.removeDirectSuperclass(rDFSClass);
            rDFSClass.removeSuperclass(this);
        }
    }

    public void removeInferredSuperclass(RDFSClass rDFSClass) {
        RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        RDFProperty rDFProperty2 = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
        this.removeOwnSlotValue(rDFProperty, rDFSClass);
        rDFSClass.removeOwnSlotValue(rDFProperty2, this);
    }

    public void setClassificationStatus(int n) {
        if (n != this.getClassificationStatus()) {
            RDFProperty rDFProperty = this.getAbstractOWLModel().getProtegeClassificationStatusProperty();
            this.setOwnSlotValue(rDFProperty, new Integer(n));
        }
    }

    public void setDefinition(RDFSClass rDFSClass) {
        for (RDFSClass rDFSClass2 : this.getEquivalentClasses()) {
            this.removeEquivalentClass(rDFSClass2);
        }
        if (rDFSClass != null) {
            this.addEquivalentClass(rDFSClass);
        }
        if (!this.hasNamedSuperClass()) {
            this.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
        }
    }

    public void setSubclassesDisjoint(boolean bl) {
        RDFProperty rDFProperty = this.getOWLModel().getProtegeSubclassesDisjointProperty();
        if (rDFProperty == null) {
            throw new RuntimeException("Could not find slot " + ProtegeNames.getSubclassesDisjointSlotName());
        }
        if (bl) {
            this.setDirectOwnSlotValue(rDFProperty, Boolean.TRUE);
            OWLUtil.ensureSubclassesDisjoint(this);
        } else {
            this.setDirectOwnSlotValues(rDFProperty, Collections.EMPTY_LIST);
            OWLUtil.removeSubclassesDisjoint(this);
        }
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLNamedClass(this);
    }
}

