/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.compactparser.OWLCompactParserUtil;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractOWLQuantifierRestriction
extends AbstractOWLRestriction
implements OWLQuantifierRestriction {
    AbstractOWLQuantifierRestriction(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    AbstractOWLQuantifierRestriction() {
    }

    public void checkFillerText(String string) throws Exception {
        RDFProperty rDFProperty = this.getOnProperty();
        if (rDFProperty != null) {
            AbstractOWLQuantifierRestriction.checkFillerText(string, rDFProperty);
        } else {
            AbstractOWLQuantifierRestriction.checkFillerText(string, rDFProperty, (OWLModel)this.getKnowledgeBase());
        }
    }

    public static void checkFillerText(String string, RDFProperty rDFProperty) throws OWLClassParseException {
        AbstractOWLQuantifierRestriction.checkFillerText(string, rDFProperty, rDFProperty.getOWLModel());
    }

    public static void checkFillerText(String string, RDFProperty rDFProperty, OWLModel oWLModel) throws OWLClassParseException {
        string = OWLCompactParserUtil.preprocessFiller(oWLModel, string);
        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
        if (string.startsWith("xsd:")) {
            if (rDFProperty instanceof OWLObjectProperty) {
                throw new OWLClassParseException(string + " cannot be applied to object properties");
            }
            oWLClassParser.checkQuantifierFiller(oWLModel, string);
        } else {
            if (rDFProperty instanceof OWLDatatypeProperty) {
                throw new OWLClassParseException(string + " cannot be applied to datatype properties");
            }
            oWLClassParser.checkClass(oWLModel, string);
        }
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof AbstractOWLQuantifierRestriction) {
            AbstractOWLQuantifierRestriction abstractOWLQuantifierRestriction = (AbstractOWLQuantifierRestriction)rDFObject;
            return this.getOperator() == abstractOWLQuantifierRestriction.getOperator() && this.getOnProperty().equalsStructurally(abstractOWLQuantifierRestriction.getOnProperty()) && this.getFiller().equalsStructurally(abstractOWLQuantifierRestriction.getFiller());
        }
        return false;
    }

    public Collection getDependingClasses() {
        if (this.getFiller() instanceof OWLAnonymousClass) {
            return Collections.singleton(this.getFiller());
        }
        return Collections.EMPTY_LIST;
    }

    public RDFResource getFiller() {
        return (RDFResource)this.getPropertyValue(this.getFillerProperty());
    }

    public String getFillerText() {
        RDFResource rDFResource = this.getFiller();
        if (rDFResource != null) {
            return rDFResource.getBrowserText();
        }
        return "";
    }

    public void getNestedNamedClasses(Set set) {
        if (this.getFiller() instanceof RDFSClass) {
            ((RDFSClass)this.getFiller()).getNestedNamedClasses(set);
        }
    }

    public void setFiller(RDFResource rDFResource) {
        this.setPropertyValue(this.getFillerProperty(), rDFResource);
    }

    public void setFillerText(String string) throws Exception {
        OWLModel oWLModel = this.getOWLModel();
        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
        if ((string = OWLCompactParserUtil.preprocessFiller(oWLModel, string)).startsWith("xsd:")) {
            RDFResource rDFResource = oWLClassParser.parseQuantifierFiller(oWLModel, string);
            if (rDFResource instanceof RDFSDatatype) {
                this.setFiller((RDFSDatatype)rDFResource);
            } else {
                OWLDataRange oWLDataRange = this.getOWLModel().createOWLDataRange((RDFSLiteral[])rDFResource);
                this.setFiller(oWLDataRange);
            }
        } else {
            RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            this.setFiller(rDFSClass);
        }
    }
}

